/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.sql.CaseFragment;
import net.sf.hibernate.sql.HSQLCaseFragment;

public class HSQLDialect
extends Dialect {
    public HSQLDialect() {
        this.registerColumnType(-5, "BIGINT");
        this.registerColumnType(-2, "BINARY");
        this.registerColumnType(-7, "BIT");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(3, "DECIMAL");
        this.registerColumnType(8, "DOUBLE");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(-4, "LONGVARBINARY");
        this.registerColumnType(-1, "LONGVARCHAR");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(-6, "TINYINT");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(12, "VARCHAR($l)");
        this.registerColumnType(-3, "VARBINARY($l)");
        this.registerColumnType(2, "NUMERIC");
        this.registerColumnType(2004, "LONGVARBINARY");
        this.registerColumnType(2005, "LONGVARCHAR");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "false");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentityColumnString() {
        return "NOT NULL IDENTITY";
    }

    public String getIdentitySelectString() {
        return "CALL IDENTITY()";
    }

    public String getIdentityInsertString() {
        return "null";
    }

    public boolean supportsForUpdate() {
        return false;
    }

    public boolean supportsUnique() {
        return false;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        return new StringBuffer(sql.length() + 10).append(sql).insert(6, hasOffset ? " limit ? ?" : " top ?").toString();
    }

    public CaseFragment createCaseFragment() {
        return new HSQLCaseFragment();
    }

    public boolean bindLimitParametersFirst() {
        return true;
    }

    public boolean supportsIfExistsAfterTableName() {
        return true;
    }

    public boolean supportsCheck() {
        return false;
    }
}

