/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.sql.CaseFragment;
import net.sf.hibernate.sql.MckoiCaseFragment;

public class MckoiDialect
extends Dialect {
    public MckoiDialect() {
        this.registerColumnType(-7, "BIT");
        this.registerColumnType(-5, "BIGINT");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(-6, "TINYINT");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(12, "VARCHAR($l)");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(8, "DOUBLE");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(-3, "VARBINARY");
        this.registerColumnType(2, "NUMERIC");
        this.registerColumnType(2004, "BLOB");
        this.registerColumnType(2005, "CLOB");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "SELECT UNIQUEKEY('" + sequenceName + "')";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "CREATE TABLE " + sequenceName + "(id NUMERIC)";
    }

    public String getDropSequenceString(String sequenceName) {
        return "DROP TABLE " + sequenceName;
    }

    public boolean supportsForUpdate() {
        return false;
    }

    public boolean supportsSequences() {
        return true;
    }

    public CaseFragment createCaseFragment() {
        return new MckoiCaseFragment();
    }
}

