/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.Comparator;
import java.util.Iterator;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.mapping.Fetchable;
import net.sf.hibernate.mapping.Formula;
import net.sf.hibernate.mapping.OneToMany;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.SimpleValue;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.mapping.Value;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.EmptyIterator;

public abstract class Collection
implements Fetchable,
Value {
    public static final String DEFAULT_ELEMENT_COLUMN_NAME = "elt";
    public static final String DEFAULT_KEY_COLUMN_NAME = "id";
    private SimpleValue key;
    private Value element;
    private Table collectionTable;
    private String role;
    private boolean lazy;
    private boolean inverse;
    private CacheConcurrencyStrategy cache;
    private String orderBy;
    private String where;
    private PersistentClass owner;
    private boolean sorted;
    private Comparator comparator;
    private boolean orphanDelete;
    private int batchSize = 1;
    private int joinedFetch;
    private Class collectionPersisterClass;

    protected Collection(PersistentClass owner) {
        this.owner = owner;
    }

    public boolean isSet() {
        return false;
    }

    public SimpleValue getKey() {
        return this.key;
    }

    public Value getElement() {
        return this.element;
    }

    public boolean isIndexed() {
        return false;
    }

    public Table getCollectionTable() {
        return this.collectionTable;
    }

    public void setCollectionTable(Table table) {
        this.collectionTable = table;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public String getRole() {
        return this.role;
    }

    public abstract PersistentCollectionType getCollectionType();

    public boolean isPrimitiveArray() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isOneToMany() {
        return this.element instanceof OneToMany;
    }

    public CacheConcurrencyStrategy getCache() {
        return this.cache;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public Class getOwnerClass() {
        return this.owner.getMappedClass();
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setCache(CacheConcurrencyStrategy cache) {
        this.cache = cache;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public void setElement(Value element) {
        this.element = element;
    }

    public void setKey(SimpleValue key) {
        this.key = key;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public PersistentClass getOwner() {
        return this.owner;
    }

    public void setOwner(PersistentClass owner) {
        this.owner = owner;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public boolean isIdentified() {
        return false;
    }

    public boolean hasOrphanDelete() {
        return this.orphanDelete;
    }

    public void setOrphanDelete(boolean orphanDelete) {
        this.orphanDelete = orphanDelete;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int i) {
        this.batchSize = i;
    }

    public int getOuterJoinFetchSetting() {
        return this.joinedFetch;
    }

    public void setOuterJoinFetchSetting(int joinedFetch) {
        this.joinedFetch = joinedFetch;
    }

    public void setCollectionPersisterClass(Class persister) {
        this.collectionPersisterClass = persister;
    }

    public Class getCollectionPersisterClass() {
        return this.collectionPersisterClass;
    }

    public void validate(Mapping mapping) throws MappingException {
        if (!this.getKey().isValid(mapping)) {
            throw new MappingException("collection foreign key mapping has wrong number of columns: " + this.getRole() + " type: " + this.getKey().getType().getName());
        }
        if (!this.getElement().isValid(mapping)) {
            throw new MappingException("collection element mapping has wrong number of columns: " + this.getRole() + " type: " + this.getElement().getType().getName());
        }
    }

    public Iterator getColumnIterator() {
        return EmptyIterator.INSTANCE;
    }

    public int getColumnSpan() {
        return 0;
    }

    public Formula getFormula() {
        return null;
    }

    public Type getType() {
        return this.getCollectionType();
    }

    public boolean isNullable() {
        return true;
    }

    public boolean isUnique() {
        return false;
    }

    public Table getTable() {
        return this.owner.getTable();
    }

    public void createForeignKey() {
    }

    public boolean isSimpleValue() {
        return false;
    }

    public boolean isValid(Mapping mapping) throws MappingException {
        return true;
    }

    private void createForeignKeys() {
        if (!this.isInverse()) {
            this.getElement().createForeignKey();
            this.getKey().createForeignKeyOfClass(this.getOwner().getMappedClass());
        }
    }

    abstract void createPrimaryKey();

    public void createAllKeys() {
        this.createForeignKeys();
        this.createPrimaryKey();
    }
}

