/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.Collections;
import java.util.Iterator;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.SimpleValue;
import net.sf.hibernate.mapping.Subclass;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.mapping.Value;

public class RootClass
extends PersistentClass {
    public static final String DEFAULT_IDENTIFIER_COLUMN_NAME = "id";
    public static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "class";
    private Property identifierProperty;
    private SimpleValue identifier;
    private Property version;
    private boolean polymorphic;
    private CacheConcurrencyStrategy cache;
    private SimpleValue discriminator;
    private boolean mutable;
    private boolean embeddedIdentifier = false;
    private boolean explicitPolymorphism;
    private Class classPersisterClass;
    private boolean forceDiscriminator;
    private String where;

    public Property getIdentifierProperty() {
        return this.identifierProperty;
    }

    public SimpleValue getIdentifier() {
        return this.identifier;
    }

    public boolean hasIdentifierProperty() {
        return this.identifierProperty != null;
    }

    public Value getDiscriminator() {
        return this.discriminator;
    }

    public boolean isInherited() {
        return false;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public void setPolymorphic(boolean polymorphic) {
        this.polymorphic = polymorphic;
    }

    public RootClass getRootClass() {
        return this;
    }

    public Iterator getPropertyClosureIterator() {
        return this.getPropertyIterator();
    }

    public Iterator getTableClosureIterator() {
        return Collections.singleton(this.getTable()).iterator();
    }

    public void addSubclass(Subclass subclass) throws MappingException {
        super.addSubclass(subclass);
        this.setPolymorphic(true);
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    public Property getVersion() {
        return this.version;
    }

    public void setVersion(Property version) {
        this.version = version;
    }

    public boolean isVersioned() {
        return this.version != null;
    }

    public CacheConcurrencyStrategy getCache() {
        return this.cache;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean hasEmbeddedIdentifier() {
        return this.embeddedIdentifier;
    }

    public Class getClassPersisterClass() {
        return this.classPersisterClass;
    }

    public Table getRootTable() {
        return this.getTable();
    }

    public void setClassPersisterClass(Class persister) {
        this.classPersisterClass = persister;
    }

    public PersistentClass getSuperclass() {
        return null;
    }

    public SimpleValue getKey() {
        return this.getIdentifier();
    }

    public void setDiscriminator(SimpleValue discriminator) {
        this.discriminator = discriminator;
    }

    public void setEmbeddedIdentifier(boolean embeddedIdentifier) {
        this.embeddedIdentifier = embeddedIdentifier;
    }

    public void setExplicitPolymorphism(boolean explicitPolymorphism) {
        this.explicitPolymorphism = explicitPolymorphism;
    }

    public void setIdentifier(SimpleValue identifier) {
        this.identifier = identifier;
    }

    public void setIdentifierProperty(Property identifierProperty) {
        this.identifierProperty = identifierProperty;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public void setCache(CacheConcurrencyStrategy cache) {
        this.cache = cache;
    }

    public boolean isForceDiscriminator() {
        return this.forceDiscriminator;
    }

    public void setForceDiscriminator(boolean forceDiscriminator) {
        this.forceDiscriminator = forceDiscriminator;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String string) {
        this.where = string;
    }

    public void validate(Mapping mapping) throws MappingException {
        super.validate(mapping);
        if (!this.getIdentifier().isValid(mapping)) {
            throw new MappingException("identifier mapping has wrong number of columns: " + this.getMappedClass().getName() + " type: " + this.getIdentifier().getType().getName());
        }
    }
}

