/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.Iterator;
import net.sf.hibernate.mapping.Collection;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.PrimaryKey;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.TypeFactory;

public class Set
extends Collection {
    public Set(PersistentClass owner) {
        super(owner);
    }

    public boolean isSet() {
        return true;
    }

    public PersistentCollectionType getCollectionType() {
        return this.isSorted() ? TypeFactory.sortedSet(this.getRole(), this.getComparator()) : TypeFactory.set(this.getRole());
    }

    void createPrimaryKey() {
        if (!this.isOneToMany()) {
            PrimaryKey pk = new PrimaryKey();
            pk.addColumns(this.getKey().getColumnIterator());
            boolean nullable = false;
            Iterator iter = this.getElement().getColumnIterator();
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                if (col.isNullable()) {
                    nullable = true;
                }
                pk.addColumn(col);
            }
            if (!nullable) {
                this.getCollectionTable().setPrimaryKey(pk);
            }
        }
    }
}

