/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.dialect.Dialect;

public class InterbaseDialect
extends Dialect {
    public InterbaseDialect() {
        this.registerColumnType(-7, "SMALLINT");
        this.registerColumnType(-5, "NUMERIC(18,0)");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(-6, "SMALLINT");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(12, "VARCHAR($l)");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(8, "DOUBLE PRECISION");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(-3, "BLOB");
        this.registerColumnType(2, "NUMERIC(18, $l)");
        this.registerColumnType(2004, "BLOB");
        this.registerColumnType(2005, "BLOB SUB_TYPE 1");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
        this.getDefaultProperties().setProperty("hibernate.statement_cache.size", "0");
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select gen_id( " + sequenceName + ", 1 ) from RDB$DATABASE";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create generator " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "delete from RDB$GENERATORS where RDB$GENERATOR_NAME = '" + sequenceName.toUpperCase() + "'";
    }

    public boolean supportsForUpdateOf() {
        return true;
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        return new StringBuffer(sql.length() + 15).append(sql).append(hasOffset ? " rows ? to ?" : " rows ?").toString();
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean bindLimitParametersInReverseOrder() {
        return false;
    }
}

