/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.CollectionSnapshot;
import net.sf.hibernate.impl.ReattachVisitor;
import net.sf.hibernate.impl.SessionImpl;
import net.sf.hibernate.type.PersistentCollectionType;

class OnLockVisitor
extends ReattachVisitor {
    public OnLockVisitor(SessionImpl session, Serializable key) {
        super(session, key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object processCollection(Object collection, PersistentCollectionType type) throws HibernateException {
        SessionImpl session = this.getSession();
        CollectionPersister persister = session.getCollectionPersister(type.getRole());
        if (collection == null) return null;
        if (!(collection instanceof PersistentCollection)) throw new HibernateException("reassociated object has dirty collection reference");
        PersistentCollection coll = (PersistentCollection)collection;
        if (!coll.setCurrentSession(session)) throw new HibernateException("reassociated object has dirty collection reference");
        CollectionSnapshot snapshot = coll.getCollectionSnapshot();
        if (!SessionImpl.isOwnerUnchanged(snapshot, persister, this.getKey())) throw new HibernateException("reassociated object has dirty collection reference");
        if (snapshot.getDirty()) {
            throw new HibernateException("reassociated object has dirty collection");
        }
        session.reattachCollection(coll, snapshot);
        return null;
    }
}

