/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.ArrayHolder;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.ProxyVisitor;
import net.sf.hibernate.impl.SessionImpl;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class WrapVisitor
extends ProxyVisitor {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$impl$WrapVisitor == null ? (class$net$sf$hibernate$impl$WrapVisitor = WrapVisitor.class$("net.sf.hibernate.impl.WrapVisitor")) : class$net$sf$hibernate$impl$WrapVisitor));
    boolean substitute = false;
    static /* synthetic */ Class class$net$sf$hibernate$impl$WrapVisitor;

    boolean isSubstitutionRequired() {
        return this.substitute;
    }

    WrapVisitor(SessionImpl session) {
        super(session);
    }

    Object processCollection(Object collection, PersistentCollectionType collectionType) throws HibernateException {
        if (collection != null && collection instanceof PersistentCollection) {
            PersistentCollection coll = (PersistentCollection)collection;
            SessionImpl session = this.getSession();
            if (coll.setCurrentSession(session)) {
                session.reattachCollection(coll, coll.getCollectionSnapshot());
            }
            return null;
        }
        return this.processArrayOrNewCollection(collection, collectionType);
    }

    final Object processArrayOrNewCollection(Object collection, PersistentCollectionType collectionType) {
        SessionImpl session = this.getSession();
        if (collection == null) {
            return null;
        }
        if (collectionType.isArrayType()) {
            ArrayHolder ah = session.getArrayHolder(collection);
            if (ah == null) {
                ah = new ArrayHolder((SessionImplementor)session, collection);
                session.addNewCollection(ah);
                session.addArrayHolder(ah);
            }
            return null;
        }
        PersistentCollection persistentCollection = collectionType.wrap(session, collection);
        session.addNewCollection(persistentCollection);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Wrapped collection in role: " + collectionType.getRole()));
        }
        return persistentCollection;
    }

    void processValues(Object[] values, Type[] types) throws HibernateException {
        for (int i = 0; i < types.length; ++i) {
            Object result = this.processValue(values[i], types[i]);
            if (result == null) continue;
            this.substitute = true;
            values[i] = result;
        }
    }

    Object processComponent(Object component, AbstractComponentType componentType) throws HibernateException {
        if (component != null) {
            Object[] values = componentType.getPropertyValues(component, this.getSession());
            Type[] types = componentType.getSubtypes();
            boolean substituteComponent = false;
            for (int i = 0; i < types.length; ++i) {
                Object result = this.processValue(values[i], types[i]);
                if (result == null) continue;
                values[i] = result;
                substituteComponent = true;
            }
            if (substituteComponent) {
                componentType.setPropertyValues(component, values);
            }
        }
        return null;
    }

    void process(Object object, ClassPersister persister) throws HibernateException {
        Object[] values = persister.getPropertyValues(object);
        Type[] types = persister.getPropertyTypes();
        this.processValues(values, types);
        if (this.isSubstitutionRequired()) {
            persister.setPropertyValues(object, values);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

