/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.QueryableCollection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.loader.CollectionInitializer;
import net.sf.hibernate.loader.OuterJoinLoader;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.persister.OuterJoinLoadable;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.Select;
import net.sf.hibernate.type.Type;

public class OneToManyLoader
extends OuterJoinLoader
implements CollectionInitializer {
    private final QueryableCollection collectionPersister;
    private final Type idType;

    protected boolean isJoinedFetchEnabled(Type type, boolean mappingDefault, String path, String table, String[] foreignKeyColumns) {
        return super.isJoinedFetchEnabled(type, mappingDefault, path, table, foreignKeyColumns) && (!table.equals(this.collectionPersister.getTableName()) || !Arrays.equals(foreignKeyColumns, this.collectionPersister.getKeyColumnNames()));
    }

    public OneToManyLoader(QueryableCollection collPersister, SessionFactoryImplementor session) throws MappingException {
        this(collPersister, 1, session);
    }

    public OneToManyLoader(QueryableCollection collPersister, int batchSize, SessionFactoryImplementor session) throws MappingException {
        super(session.getDialect());
        this.collectionPersister = collPersister;
        this.idType = collPersister.getKeyType();
        OuterJoinLoadable persister = (OuterJoinLoadable)collPersister.getElementPersister();
        String alias = this.generateRootAlias(collPersister.getRole());
        List associations = this.walkTree(persister, alias, session);
        int joins = associations.size();
        this.suffixes = OneToManyLoader.generateSuffixes(joins + 1);
        this.sql = this.renderStatementString(collPersister, persister, alias, associations, batchSize, session);
        this.classPersisters = new Loadable[joins + 1];
        this.lockModeArray = this.createLockModeArray(joins + 1, LockMode.NONE);
        for (int i = 0; i < joins; ++i) {
            this.classPersisters[i] = (Loadable)((Object)((OuterJoinLoader.OuterJoinableAssociation)associations.get((int)i)).joinable);
        }
        this.classPersisters[joins] = persister;
        this.postInstantiate();
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    public void initialize(Serializable id, SessionImplementor session) throws SQLException, HibernateException {
        this.loadCollection(session, id, this.idType);
    }

    public final String renderStatementString(QueryableCollection collPersister, OuterJoinLoadable persister, String alias, List associations, int batchSize, SessionFactoryImplementor factory) throws MappingException {
        StringBuffer whereString = OneToManyLoader.whereString(alias, collPersister.getKeyColumnNames(), batchSize);
        if (collPersister.hasWhere()) {
            whereString.append(" and ").append(collPersister.getSQLWhereString(alias));
        }
        int joins = associations.size();
        JoinFragment ojf = this.mergeOuterJoins(associations);
        Select select = new Select().setSelectClause(collPersister.selectClauseFragment(alias) + this.selectString(associations, factory) + ", " + persister.selectFragment(alias, this.suffixes[joins])).setFromClause(persister.fromTableFragment(alias) + persister.fromJoinFragment(alias, true, true)).setWhereClause(whereString.toString()).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString() + persister.whereJoinFragment(alias, true, true));
        if (collPersister.hasOrdering()) {
            select.setOrderByClause(collPersister.getSQLOrderByString(alias));
        }
        return select.toStatementString();
    }
}

