/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.engine.QueryParameters;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.loader.OuterJoinLoader;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.persister.SQLLoadable;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.StringHelper;

public class SQLLoader
extends OuterJoinLoader {
    private int parameterCount = 0;
    private final Map namedParameters = new HashMap();
    private final String sqlQuery;
    private final Map alias2Persister;
    private final String[] aliases;
    private Set querySpaces = new HashSet();
    private Type[] resultTypes;

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    public SQLLoader(String[] aliases, SQLLoadable[] persisters, SessionFactoryImplementor factory, String sqlQuery, Collection additionalQuerySpaces) throws HibernateException {
        super(factory.getDialect());
        this.sqlQuery = sqlQuery;
        this.aliases = aliases;
        this.alias2Persister = new HashMap(persisters.length);
        ArrayList<Type> resultTypeList = new ArrayList<Type>();
        for (int i = 0; i < persisters.length; ++i) {
            SQLLoadable persister = persisters[i];
            this.alias2Persister.put(aliases[i], persister);
            ArrayHelper.addAll(this.querySpaces, persister.getPropertySpaces());
            resultTypeList.add(persister.getType());
        }
        if (additionalQuerySpaces != null) {
            this.querySpaces.addAll(additionalQuerySpaces);
        }
        this.resultTypes = resultTypeList.toArray(ArrayHelper.EMPTY_TYPE_ARRAY);
        this.renderStatement(persisters);
        this.postInstantiate();
    }

    private void renderStatement(Loadable[] persisters) throws QueryException {
        int loadables = persisters.length;
        this.classPersisters = persisters;
        this.suffixes = SQLLoader.generateSuffixes(loadables);
        this.lockModeArray = this.createLockModeArray(loadables, LockMode.NONE);
        this.sql = this.substituteBrackets();
        this.sql = this.substituteParams();
    }

    public List list(SessionImplementor session, QueryParameters queryParameters) throws HibernateException, SQLException {
        return this.list(session, queryParameters, this.querySpaces, this.resultTypes);
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        if (this.classPersisters.length == 1) {
            return row[row.length - 1];
        }
        return row;
    }

    public String substituteBrackets() throws QueryException {
        String sqlString = this.sqlQuery;
        StringBuffer result = new StringBuffer();
        int curr = 0;
        while (curr < sqlString.length()) {
            int left = sqlString.indexOf(123, curr);
            if (left < 0) {
                result.append(sqlString.substring(curr));
                break;
            }
            result.append(sqlString.substring(curr, left));
            int right = sqlString.indexOf(125, left + 1);
            if (right < 0) {
                throw new QueryException("Unmatched braces for alias path", sqlString);
            }
            String aliasPath = sqlString.substring(left + 1, right);
            int firstDot = aliasPath.lastIndexOf(46);
            String aliasName = firstDot == -1 ? aliasPath : aliasPath.substring(0, firstDot);
            SQLLoadable currentPersister = this.getPersisterByResultAlias(aliasName);
            if (currentPersister == null) {
                throw new QueryException("Alias [" + aliasName + "] does not correspond to any of the supplied return aliases = {" + ArrayHelper.asString(this.aliases) + "}", this.sqlQuery);
            }
            int currentPersisterIndex = this.getPersisterIndex(currentPersister);
            if (firstDot == -1) {
                result.append(aliasPath);
            } else {
                if (!aliasName.equals(this.aliases[currentPersisterIndex])) {
                    throw new QueryException("Alias [" + aliasName + "] does not correspond to return alias " + this.aliases[currentPersisterIndex], this.sqlQuery);
                }
                String propertyName = aliasPath.substring(firstDot + 1);
                if ("*".equals(propertyName)) {
                    result.append(currentPersister.selectFragment(aliasName, this.suffixes[currentPersisterIndex]));
                } else {
                    String[] columnAliases = currentPersister.getSubclassPropertyColumnAliases(propertyName, this.suffixes[currentPersisterIndex]);
                    if (columnAliases == null || columnAliases.length == 0) {
                        throw new QueryException("No column name found for property [" + propertyName + "]", this.sqlQuery);
                    }
                    if (columnAliases.length != 1) {
                        throw new QueryException("SQL queries only support properties mapped to a single column. Property [" + propertyName + "] is mapped to " + columnAliases.length + " columns.", this.sqlQuery);
                    }
                    result.append(columnAliases[0]);
                }
            }
            curr = right + 1;
        }
        return result.toString();
    }

    private String substituteParams() {
        String sqlString = this.sql;
        StringBuffer result = new StringBuffer(this.sql.length());
        int curr = 0;
        while (curr < sqlString.length()) {
            int left = sqlString.indexOf(":", curr);
            if (left < 0) {
                result.append(sqlString.substring(curr));
                break;
            }
            result.append(sqlString.substring(curr, left));
            int right = StringHelper.firstIndexOfChar(sqlString, " \n\r\f\t,()=<>&|+-=/*'^![]#~\\", left + 1);
            boolean foundSeperator = right > 0;
            int chopLocation = -1;
            chopLocation = right < 0 ? sqlString.length() : right;
            String param = sqlString.substring(left + 1, chopLocation);
            this.addNamedParameter(param);
            result.append("?");
            if (!foundSeperator) break;
            result.append(sqlString.charAt(right));
            curr = right + 1;
        }
        return result.toString();
    }

    private int getPersisterIndex(Loadable currentPersister) {
        for (int i = 0; i < this.classPersisters.length; ++i) {
            if (currentPersister != this.classPersisters[i]) continue;
            return i;
        }
        return -1;
    }

    private SQLLoadable getPersisterByResultAlias(String aliasName) {
        return (SQLLoadable)this.alias2Persister.get(aliasName);
    }

    void addNamedParameter(String name) {
        Integer loc = new Integer(this.parameterCount++);
        Object o = this.namedParameters.get(name);
        if (o == null) {
            this.namedParameters.put(name, loc);
        } else if (o instanceof Integer) {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(o);
            list.add(loc);
            this.namedParameters.put(name, list);
        } else {
            ((List)o).add(loc);
        }
    }

    protected int[] getNamedParameterLocs(String name) throws QueryException {
        Object o = this.namedParameters.get(name);
        if (o == null) {
            QueryException qe = new QueryException("Named parameter does not appear in Query: " + name, this.sqlQuery);
            throw qe;
        }
        if (o instanceof Integer) {
            return new int[]{(Integer)o};
        }
        return ArrayHelper.toIntArray((List)o);
    }

    protected int bindNamedParameters(PreparedStatement ps, Map namedParams, int start, SessionImplementor session) throws SQLException, HibernateException {
        if (namedParams != null) {
            Iterator iter = namedParams.entrySet().iterator();
            int result = 0;
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                String name = (String)e.getKey();
                TypedValue typedval = (TypedValue)e.getValue();
                int[] locs = this.getNamedParameterLocs(name);
                for (int i = 0; i < locs.length; ++i) {
                    typedval.getType().nullSafeSet(ps, typedval.getValue(), locs[i] + start, session);
                }
                result += locs.length;
            }
            return result;
        }
        return 0;
    }
}

