/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.xml.JobSchedulingBundle;
import org.quartz.xml.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JobSchedulingDataProcessor
extends DefaultHandler {
    public static final String QUARTZ_SYSTEM_ID = "job_scheduling_data_1_0.dtd";
    public static final String QUARTZ_SYSTEM_ID_DIR_PROP = "quartz.system.id.dir";
    public static final String QUARTZ_XML_FILE_NAME = "quartz_jobs.xml";
    public static final String QUARTZ_SYSTEM_ID_PREFIX = "jar:";
    protected static final String TAG_QUARTZ = "quartz";
    protected static final String TAG_JOB = "job";
    protected static final String TAG_JOB_DETAIL = "job-detail";
    protected static final String TAG_NAME = "name";
    protected static final String TAG_GROUP = "group";
    protected static final String TAG_JOB_CLASS = "job-class";
    protected static final String TAG_VOLATILITY = "volatility";
    protected static final String TAG_DURABILITY = "durability";
    protected static final String TAG_RECOVER = "recover";
    protected static final String TAG_TRIGGER = "trigger";
    protected static final String TAG_SIMPLE = "simple";
    protected static final String TAG_CRON = "cron";
    protected static final String TAG_JOB_NAME = "job-name";
    protected static final String TAG_JOB_GROUP = "job-group";
    protected static final String TAG_START_TIME = "start-time";
    protected static final String TAG_END_TIME = "end-time";
    protected static final String TAG_REPEAT_COUNT = "repeat-count";
    protected static final String TAG_REPEAT_INTERVAL = "repeat-interval";
    protected static final String TAG_CRON_EXPRESSION = "cron-expression";
    protected static final String TAG_TIME_ZONE = "time-zone";
    protected static final String[] TAGS_JOB_DETAIL = new String[]{"name", "group", "job-class", "volatility", "durability", "recover"};
    protected static final String[] TAGS_JOB_DETAIL_OPTIONS = new String[]{"volatility", "durability", "recover"};
    protected static final String[] TAGS_TRIGGER = new String[]{"name", "group", "job-name", "job-group", "start-time", "end-time", "repeat-count", "repeat-interval", "cron-expression", "time-zone"};
    protected static final String DATE_FORMAT = "yyyy-MM-dd hh:mm:ss a";
    protected final DateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a");
    protected Map scheduledJobs = new HashMap();
    protected Collection validationExceptions = new ArrayList();
    static /* synthetic */ Class class$org$quartz$xml$JobSchedulingDataProcessor;

    protected static Log getLog() {
        return LogFactory.getLog((Class)(class$org$quartz$xml$JobSchedulingDataProcessor == null ? (class$org$quartz$xml$JobSchedulingDataProcessor = JobSchedulingDataProcessor.class$("org.quartz.xml.JobSchedulingDataProcessor")) : class$org$quartz$xml$JobSchedulingDataProcessor));
    }

    public void processFile() throws Exception {
        this.processFile(QUARTZ_XML_FILE_NAME);
    }

    public void processFile(String fileName) throws Exception {
        this.processFile(fileName, null);
    }

    public void processFile(String fileName, String systemId) throws ValidationException, ParserConfigurationException, SAXException, IOException, SchedulerException, ClassNotFoundException, ParseException {
        this.clearValidationExceptions();
        this.scheduledJobs.clear();
        Document doc = this.getDocument(fileName, systemId);
        this.parseDocument(doc);
        this.maybeThrowValidationException();
    }

    public void processFileAndScheduleJobs(Scheduler sched, boolean overWriteExistingJobs) throws SchedulerException, Exception {
        this.processFileAndScheduleJobs(QUARTZ_XML_FILE_NAME, sched, overWriteExistingJobs);
    }

    public void processFileAndScheduleJobs(String fileName, Scheduler sched, boolean overWriteExistingJobs) throws Exception {
        this.processFile(fileName, null);
        this.scheduleJobs(this.getScheduledJobs(), sched, overWriteExistingJobs);
    }

    public void scheduleJobs(Map jobBundles, Scheduler sched, boolean overWriteExistingJobs) throws Exception {
        JobSchedulingDataProcessor.getLog().info((Object)("Scheduling " + jobBundles.size() + " parsed jobs."));
        Iterator itr = jobBundles.values().iterator();
        while (itr.hasNext()) {
            JobSchedulingBundle bndle = (JobSchedulingBundle)itr.next();
            JobDetail detail = bndle.getJobDetail();
            Trigger trigger = bndle.getTrigger();
            JobDetail dupeJ = sched.getJobDetail(detail.getName(), detail.getGroup());
            Trigger dupeT = sched.getTrigger(trigger.getName(), trigger.getGroup());
            if ((dupeJ != null || dupeT != null) && !overWriteExistingJobs) continue;
            if (dupeT != null) {
                JobSchedulingDataProcessor.getLog().debug((Object)("Unscheduling existing job: " + dupeT.getFullJobName()));
                sched.unscheduleJob(dupeT.getName(), dupeT.getGroup());
            }
            if (dupeJ != null) {
                JobSchedulingDataProcessor.getLog().debug((Object)("Replacing job: " + detail.getFullName()));
            } else {
                JobSchedulingDataProcessor.getLog().debug((Object)("Adding job: " + detail.getFullName()));
            }
            sched.addJob(detail, true);
            trigger.setJobName(detail.getName());
            trigger.setJobGroup(detail.getGroup());
            JobSchedulingDataProcessor.getLog().debug((Object)("Scheduling job: " + detail.getFullName() + " with trigger: " + trigger.getFullName()));
            sched.scheduleJob(trigger);
        }
    }

    public Map getScheduledJobs() {
        return Collections.unmodifiableMap(this.scheduledJobs);
    }

    public JobSchedulingBundle getScheduledJob(String name) {
        return (JobSchedulingBundle)this.getScheduledJobs().get(name);
    }

    protected Document getDocument(String fileName, String systemId) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(this);
        builder.setErrorHandler(this);
        InputStream is = this.getInputStream(fileName);
        Document doc = null;
        doc = systemId != null && systemId.trim().length() > 0 ? builder.parse(is, systemId) : builder.parse(is);
        return doc;
    }

    protected InputStream getInputStream(String fileName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(fileName);
        return is;
    }

    protected void scheduleJob(JobSchedulingBundle job) throws SchedulerException {
        if (job != null && job.isValid()) {
            StdSchedulerFactory.getDefaultScheduler().scheduleJob(job.getJobDetail(), job.getTrigger());
            this.addScheduledJob(job);
        }
    }

    protected void addScheduledJob(JobSchedulingBundle job) {
        this.scheduledJobs.put(job.getName(), job);
    }

    protected void parseDocument(Document doc) throws ValidationException, ClassNotFoundException, ParseException, SchedulerException {
        Element root = doc.getDocumentElement();
        if (root != null) {
            Element element = null;
            if (root instanceof Element) {
                element = root;
                this.parseJobs(element.getElementsByTagName(TAG_JOB));
            }
        }
    }

    protected void parseJobs(NodeList nodes) throws ValidationException, ClassNotFoundException, ParseException, SchedulerException {
        if (nodes != null) {
            int len = nodes.getLength();
            int i = 0;
            while (i < len) {
                Node node = nodes.item(i);
                this.parseJob(node);
                ++i;
            }
        }
    }

    protected void parseJob(Node node) throws ValidationException, ClassNotFoundException, ParseException, SchedulerException {
        JobSchedulingBundle job = new JobSchedulingBundle();
        Node jobDetailNode = this.getSingleElementByTagName(node, TAG_JOB_DETAIL);
        this.parseJobDetail(jobDetailNode, job);
        Node triggerNode = this.getSingleElementByTagName(node, TAG_TRIGGER);
        this.parseTrigger(triggerNode, job);
        this.addScheduledJob(job);
    }

    protected void parseJobDetail(Node node, JobSchedulingBundle job) throws ValidationException, ClassNotFoundException {
        Map nodes = this.getSingleElementsByTagName(node, TAGS_JOB_DETAIL);
        JobDetail jobDetail = null;
        String name = this.getNodeValue(nodes, TAG_NAME);
        this.validate(name);
        String group = this.getNodeValue(nodes, TAG_GROUP);
        this.validate(group);
        String jobClassName = this.getNodeValue(nodes, TAG_JOB_CLASS);
        this.validate(jobClassName);
        Class<?> jobClass = jobClassName != null ? Class.forName(jobClassName) : null;
        String volatility = this.getNodeValue(nodes, TAG_VOLATILITY);
        String durability = this.getNodeValue(nodes, TAG_DURABILITY);
        String recover = this.getNodeValue(nodes, TAG_RECOVER);
        jobDetail = !this.validate(TAGS_JOB_DETAIL_OPTIONS) ? new JobDetail(name, group, jobClass) : new JobDetail(name, group, jobClass, Boolean.valueOf(volatility), Boolean.valueOf(durability), Boolean.valueOf(recover));
        if (this.isValid(jobDetail)) {
            job.setJobDetail(jobDetail);
        }
    }

    protected void parseTrigger(Node node, JobSchedulingBundle job) throws ValidationException, ParseException {
        String tag = TAG_SIMPLE;
        Node child = this.getSingleElementByTagName(node, tag);
        if (child == null) {
            tag = TAG_CRON;
            child = this.getSingleElementByTagName(node, tag);
        }
        Map nodes = this.getSingleElementsByTagName(node, TAGS_TRIGGER);
        String name = this.getNodeValue(nodes, TAG_NAME);
        this.validate(name);
        String group = this.getNodeValue(nodes, TAG_GROUP);
        this.validate(group);
        String jobName = this.getNodeValue(nodes, TAG_JOB_NAME);
        String jobGroup = this.getNodeValue(nodes, TAG_JOB_GROUP);
        String startTime = this.getNodeValue(nodes, TAG_START_TIME);
        String endTime = this.getNodeValue(nodes, TAG_END_TIME);
        String repeatCount = this.getNodeValue(nodes, TAG_REPEAT_COUNT);
        String repeatInterval = this.getNodeValue(nodes, TAG_REPEAT_INTERVAL);
        String cronExpression = this.getNodeValue(nodes, TAG_CRON_EXPRESSION);
        String timeZoneId = this.getNodeValue(nodes, TAG_TIME_ZONE);
        Trigger trigger = null;
        if (TAG_SIMPLE.equals(tag)) {
            trigger = this.parseSimpleTrigger(name, group, jobName, jobGroup, startTime, endTime, repeatCount, repeatInterval);
        } else if (TAG_CRON.equals(tag)) {
            trigger = this.parseCronTrigger(name, group, jobName, jobGroup, startTime, endTime, cronExpression, timeZoneId);
        }
        if (this.isValid(trigger)) {
            job.setTrigger(trigger);
        }
    }

    protected SimpleTrigger parseSimpleTrigger(String triggerName, String triggerGroup, String jobName, String jobGroup, String startTime, String endTime, String repeatCount, String repeatInterval) throws ValidationException, ParseException {
        SimpleTrigger trigger = null;
        Date startTimeDate = null;
        if (this.isValid(triggerName) && this.isValid(triggerGroup)) {
            if (this.isValid(startTime)) {
                startTimeDate = this.FORMATTER.parse(startTime);
            }
            if (this.isValid(repeatCount) && this.isValid(repeatInterval)) {
                int repeatCountNum = Integer.parseInt(repeatCount);
                long repeatIntervalNum = Integer.parseInt(repeatInterval);
                if (this.isValid(startTime)) {
                    if (this.isValid(endTime)) {
                        Date endTimeDate = this.FORMATTER.parse(endTime);
                        trigger = this.isValid(jobName) && this.isValid(jobGroup) ? new SimpleTrigger(triggerName, triggerGroup, jobName, jobGroup, startTimeDate, endTimeDate, repeatCountNum, repeatIntervalNum) : new SimpleTrigger(triggerName, triggerGroup, startTimeDate, endTimeDate, repeatCountNum, repeatIntervalNum);
                    }
                } else {
                    trigger = new SimpleTrigger(triggerName, triggerGroup, repeatCountNum, repeatIntervalNum);
                }
            } else {
                trigger = startTimeDate != null ? new SimpleTrigger(triggerName, triggerGroup, startTimeDate) : new SimpleTrigger(triggerName, triggerGroup);
            }
        }
        return trigger;
    }

    protected CronTrigger parseCronTrigger(String triggerName, String triggerGroup, String jobName, String jobGroup, String startTime, String endTime, String cronExpression, String timeZoneId) throws ValidationException, ParseException {
        CronTrigger trigger = null;
        if (this.isValid(triggerName) && this.isValid(triggerGroup)) {
            if (this.isValid(jobName) && this.isValid(jobGroup)) {
                if (this.isValid(cronExpression)) {
                    TimeZone timeZone = null;
                    if (this.isValid(timeZoneId)) {
                        timeZone = TimeZone.getTimeZone(timeZoneId);
                    }
                    if (this.isValid(startTime) && this.isValid(endTime)) {
                        Date startTimeDate = this.FORMATTER.parse(startTime);
                        Date endTimeDate = this.FORMATTER.parse(endTime);
                        trigger = timeZone != null ? new CronTrigger(triggerName, triggerGroup, jobName, jobGroup, startTimeDate, endTimeDate, cronExpression, timeZone) : new CronTrigger(triggerName, triggerGroup, jobName, jobGroup, startTimeDate, endTimeDate, cronExpression);
                    } else {
                        trigger = timeZone != null ? new CronTrigger(triggerName, triggerGroup, jobName, jobGroup, cronExpression, timeZone) : new CronTrigger(triggerName, triggerGroup, jobName, jobGroup, cronExpression);
                    }
                } else {
                    trigger = new CronTrigger(triggerName, triggerGroup, jobName, jobGroup);
                }
            } else {
                trigger = new CronTrigger(triggerName, triggerGroup);
            }
        }
        return trigger;
    }

    protected Node getSingleElementByTagName(Node node, String name) {
        Node singleNode = null;
        Map elements = this.getSingleElementsByTagName(node, new String[]{name});
        if (elements.size() == 1) {
            singleNode = (Node)elements.get(name);
        }
        return singleNode;
    }

    protected Map getSingleElementsByTagName(Node node, String[] names) {
        Element element = null;
        HashMap<String, Node> elements = new HashMap<String, Node>();
        if (node instanceof Element) {
            element = (Element)node;
            int len = names.length;
            NodeList nodes = null;
            int i = 0;
            while (i < len) {
                nodes = element.getElementsByTagName(names[i]);
                if (nodes.getLength() == 1) {
                    elements.put(names[i], nodes.item(0));
                }
                ++i;
            }
        }
        return elements;
    }

    protected String getNodeValue(Map nodes, String tagName) {
        Node childNode;
        String value = null;
        Node node = (Node)nodes.get(tagName);
        if (node != null && (childNode = node.getFirstChild()) != null && childNode instanceof Text) {
            value = childNode.getNodeValue();
        }
        return value;
    }

    protected boolean isValid(String s) {
        return s != null && s.trim().length() > 0;
    }

    protected boolean isValid(JobDetail jobDetail) {
        return jobDetail != null && this.isValid(jobDetail.getName()) && this.isValid(jobDetail.getGroup()) && jobDetail.getClass() != null;
    }

    protected boolean isValid(Trigger trigger) {
        return trigger != null && this.isValid(trigger.getName()) && this.isValid(trigger.getGroup());
    }

    protected boolean validate(String tag) throws ValidationException {
        if (!this.isValid(tag)) {
            throw new ValidationException("Missing tag: " + tag);
        }
        return true;
    }

    protected boolean validate(String[] tags) throws ValidationException {
        int valid = 0;
        int len = tags.length;
        int validValue = (1 << len) - 1;
        int i = 0;
        while (i < len) {
            if (this.isValid(tags[i])) {
                valid |= 1 << i;
            }
            ++i;
        }
        if (valid != validValue) {
            throw new ValidationException("Missing tag: " + tags.toString());
        }
        return valid != 0;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource inputSource = null;
        InputStream is = null;
        URL url = null;
        try {
            block13: {
                try {
                    if (publicId == null) {
                        if (systemId != null && (is = this.getInputStream(systemId)) == null) {
                            int start = systemId.indexOf(QUARTZ_SYSTEM_ID_PREFIX);
                            if (start > -1) {
                                String fileName = systemId.substring(QUARTZ_SYSTEM_ID_PREFIX.length());
                                is = this.getInputStream(fileName);
                            } else {
                                if (systemId.indexOf(58) == -1) {
                                    File file = new File(systemId);
                                    url = file.toURL();
                                } else {
                                    url = new URL(systemId);
                                }
                                is = url.openStream();
                            }
                        }
                        break block13;
                    }
                    url = new URL(systemId);
                    is = url.openStream();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var9_11 = null;
                    if (is != null) {
                        inputSource = new InputSource(is);
                        inputSource.setPublicId(publicId);
                        inputSource.setSystemId(systemId);
                    }
                }
            }
            Object var9_10 = null;
            if (is != null) {
                inputSource = new InputSource(is);
                inputSource.setPublicId(publicId);
                inputSource.setSystemId(systemId);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (is != null) {
                inputSource = new InputSource(is);
                inputSource.setPublicId(publicId);
                inputSource.setSystemId(systemId);
            }
            throw throwable;
        }
        return inputSource;
    }

    public void warning(SAXException e) throws SAXException {
        this.addValidationException(e);
    }

    public void error(SAXException e) throws SAXException {
        this.addValidationException(e);
    }

    public void fatalError(SAXException e) throws SAXException {
        this.addValidationException(e);
    }

    protected void addValidationException(SAXException e) {
        this.validationExceptions.add(e);
    }

    protected void clearValidationExceptions() {
        this.validationExceptions.clear();
    }

    protected void maybeThrowValidationException() throws ValidationException {
        if (this.validationExceptions.size() > 0) {
            throw new ValidationException(this.validationExceptions);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

