/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j;

import churchillobjects.rss4j.model.DateLanguageUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;

public class RssSyndication
implements Cloneable,
Serializable {
    public static final String XMLNS = "xmlns:sy";
    public static final String PREFIX = "sy";
    public static final String XMLNS_VALUE = "http://purl.org/rss/1.0/modules/syndication/";
    public static final String HOURLY = "hourly";
    public static final String DAILY = "daily";
    public static final String WEEKLY = "weekly";
    public static final String MONTHLY = "monthly";
    public static final String YEARLY = "yearly";
    private String updatePeriod = "daily";
    private int updateFrequency = 1;
    private String updateBase;
    private Date updateBaseDate;

    public RssSyndication() {
    }

    public RssSyndication(String string, int n, String string2) throws ParseException {
        this.setUpdateBase(string2);
        this.setUpdatePeriod(string);
        this.updateFrequency = n;
    }

    public RssSyndication(String string, int n, Date date) {
        this.setUpdateBase(date);
        this.setUpdatePeriod(string);
        this.updateFrequency = n;
    }

    public void setUpdateBase(String string) throws ParseException {
        this.updateBaseDate = DateLanguageUtil.convert8601ToDate(string);
        this.updateBase = string;
    }

    public void setUpdateBase(Date date) {
        this.updateBaseDate = date;
        this.updateBase = DateLanguageUtil.convertDateTo8601(date);
    }

    public void setUpdatePeriod(String string) {
        if (!(HOURLY.equals(string) || DAILY.equals(string) || WEEKLY.equals(string) || MONTHLY.equals(string) || YEARLY.equals(string))) {
            throw new IllegalArgumentException("Invalid update period: '" + string + "' - must be one of {'" + HOURLY + "', '" + DAILY + "', '" + WEEKLY + "', '" + MONTHLY + "', '" + YEARLY + "'}");
        }
        this.updatePeriod = string;
    }

    public void setUpdateFrequency(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Update frequency must be positive integer: " + n);
        }
        this.updateFrequency = n;
    }

    public String getUpdatePeriod() {
        return this.updatePeriod;
    }

    public int getUpdateFrequency() {
        return this.updateFrequency;
    }

    public String getUpdateBase() {
        return this.updateBase;
    }

    public Date getUpdateBaseAsDate() {
        return this.updateBaseDate;
    }

    public String toString() {
        return "[updatePeriod='" + this.updatePeriod + "', updateFrequency='" + this.updateFrequency + "', updateBase='" + this.updateBase + "']";
    }

    public int hashCode() {
        int n = this.updatePeriod == null ? 0 : this.updatePeriod.hashCode();
        n = 31 * n + this.updateFrequency;
        n = 31 * n + (this.updateBase == null ? 0 : this.updateBase.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RssSyndication)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.hashCode() == object.hashCode();
    }

    public Object clone() {
        return this.clone();
    }
}

