/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.generator;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelImage;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssChannelTextInput;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.generator.RssGenerationException;
import churchillobjects.rss4j.generator.RssGeneratorImpl090;
import churchillobjects.rss4j.model.DateLanguageUtil;
import java.util.Enumeration;
import org.w3c.dom.Element;

class RssGeneratorImpl091
extends RssGeneratorImpl090 {
    private static final String DOCTYPE = "-//Netscape Communications//DTD RSS 0.91//EN";
    private static final String DTD = "http://my.netscape.com/publish/formats/rss-0.91.dtd";
    private static final String VERSION = "0.91";

    RssGeneratorImpl091() throws RssGenerationException {
    }

    protected void setMaxLengths() {
        super.setMaxLengths();
        this.channelTitleMax = 100;
        this.channelLinkMax = 500;
        this.channelPubDate = 100;
        this.channelBuildDate = 100;
        this.channelManagingEditorMax = 100;
        this.channelWebmasterMax = 100;
        this.channelCopyrightMax = 100;
        this.channelDocsMax = 500;
        this.imageTitleMax = 100;
        this.imageDescriptionMax = 100;
        this.itemDescriptionMax = 500;
        this.textInputTitleMax = 100;
        this.textInputDescriptionMax = 500;
        this.textInputNameMax = 20;
        this.textInputLinkMax = 500;
    }

    protected void createRssDocument(RssDocument rssDocument) {
        this.doc = this.domImpl.createDocument(null, "rss", null);
        this.rootElement = this.doc.getDocumentElement();
        this.rootElement.setAttribute("version", VERSION);
    }

    protected void handleChannel(RssChannel rssChannel) throws RssGenerationException {
        Element element = this.doc.createElement("channel");
        this.rootElement.appendChild(element);
        this.handleChannelTitle(rssChannel, element);
        this.handleChannelDescription(rssChannel, element);
        this.handleChannelLink(rssChannel, element);
        this.handleChannelLanguage(rssChannel, element);
        this.handleChannelPicsRating(rssChannel, element);
        this.handleChannelPubDate(rssChannel, element);
        this.handleChannelBuildDate(rssChannel, element);
        this.handleChannelManagingEditor(rssChannel, element);
        this.handleChannelWebmaster(rssChannel, element);
        this.handleChannelCopyright(rssChannel, element);
        this.handleChannelDocs(rssChannel, element);
        this.handleSkipDays(rssChannel, element);
        this.handleSkipHours(rssChannel, element);
        this.handleTextInput(rssChannel, element);
        this.handleImage(rssChannel, element);
        this.handleItems(rssChannel, element);
    }

    protected void handleSkipDays(RssChannel rssChannel, Element element) {
        Enumeration enumeration = rssChannel.skipDays();
        if (enumeration.hasMoreElements()) {
            Element element2 = this.doc.createElement("skipDays");
            while (enumeration.hasMoreElements()) {
                this.add(element2, "day", (String)enumeration.nextElement());
            }
            element.appendChild(element2);
        }
    }

    protected void handleSkipHours(RssChannel rssChannel, Element element) {
        Enumeration enumeration = rssChannel.skipHours();
        if (enumeration.hasMoreElements()) {
            Element element2 = this.doc.createElement("skipHours");
            while (enumeration.hasMoreElements()) {
                this.add(element2, "hour", enumeration.nextElement().toString());
            }
            element.appendChild(element2);
        }
    }

    protected void handleImage(RssChannel rssChannel, Element element) throws RssGenerationException {
        RssChannelImage rssChannelImage = rssChannel.getChannelImage();
        if (rssChannelImage != null) {
            Element element2 = this.doc.createElement("image");
            this.handleImageTitle(rssChannelImage, element2);
            this.handleImageUrl(rssChannelImage, element2);
            this.handleImageLink(rssChannelImage, element2);
            this.handleImageDescription(rssChannelImage, element2);
            this.handleImageHeight(rssChannelImage, element2);
            this.handleImageWidth(rssChannelImage, element2);
            element.appendChild(element2);
        }
    }

    protected void handleItems(RssChannel rssChannel, Element element) throws RssGenerationException {
        if (rssChannel.getItemCount() > 15) {
            throw new RssGenerationException("Channel in 0.91 RSS can only have 15 items");
        }
        Enumeration enumeration = rssChannel.items();
        while (enumeration.hasMoreElements()) {
            RssChannelItem rssChannelItem = (RssChannelItem)enumeration.nextElement();
            Element element2 = this.doc.createElement("item");
            this.handleItemTitle(rssChannelItem, element2);
            this.handleItemLink(rssChannelItem, element2);
            this.handleItemDescription(rssChannelItem, element2);
            element.appendChild(element2);
        }
    }

    protected void handleTextInput(RssChannel rssChannel, Element element) throws RssGenerationException {
        RssChannelTextInput rssChannelTextInput = rssChannel.getChannelTextInput();
        if (rssChannelTextInput != null) {
            Element element2 = this.doc.createElement("textInput");
            this.handleTextInputTitle(rssChannelTextInput, element2);
            this.handleTextInputDescription(rssChannelTextInput, element2);
            this.handleTextInputName(rssChannelTextInput, element2);
            this.handleTextInputLink(rssChannelTextInput, element2);
            element.appendChild(element2);
        }
    }

    protected void handleChannelLanguage(RssChannel rssChannel, Element element) throws RssGenerationException {
        String string = rssChannel.getChannelLanguage();
        if (!DateLanguageUtil.isValidLanguage(string)) {
            throw new RssGenerationException("Channel language unknown or null: " + string);
        }
        this.add(element, "language", string);
    }

    protected void handleChannelPicsRating(RssChannel rssChannel, Element element) throws RssGenerationException {
        String string = rssChannel.getChannelPicsRating();
        this.validateValueOptional(string, "Channel PICS rating", 20, 500);
        this.add(element, "rating", string);
    }

    protected void handleChannelPubDate(RssChannel rssChannel, Element element) throws RssGenerationException {
        String string = rssChannel.getChannelPubDate();
        string = this.truncate(string, 100);
        this.validateValueOptional(string, "Channel pub date", 100);
        this.add(element, "pubDate", string);
    }

    protected void handleChannelBuildDate(RssChannel rssChannel, Element element) throws RssGenerationException {
        String string = rssChannel.getChannelLastBuildDate();
        string = this.truncate(string, 100);
        this.validateValueOptional(string, "Channel last build date", 100);
        this.add(element, "lastBuildDate", string);
    }

    protected void handleChannelManagingEditor(RssChannel rssChannel, Element element) throws RssGenerationException {
        String string = rssChannel.getChannelManagingEditor();
        string = this.truncate(string, 100);
        this.validateValueOptional(string, "Channel managing editor", 100);
        this.add(element, "managingEditor", string);
    }

    protected void handleChannelWebmaster(RssChannel rssChannel, Element element) throws RssGenerationException {
        String string = rssChannel.getChannelWebmaster();
        string = this.truncate(string, 100);
        this.validateValueOptional(string, "Channel webmaster", 100);
        this.add(element, "webMaster", string);
    }

    protected void handleChannelCopyright(RssChannel rssChannel, Element element) throws RssGenerationException {
        String string = rssChannel.getChannelCopyright();
        string = this.truncate(string, 100);
        this.validateValueOptional(string, "Channel copyright", 100);
        this.add(element, "copyright", string);
    }

    protected void handleChannelDocs(RssChannel rssChannel, Element element) throws RssGenerationException {
        String string = rssChannel.getChannelDocs();
        this.validateUri(string);
        this.validateValueOptional(string, "Channel docs", 500);
        this.add(element, "docs", string);
    }

    protected void handleImageDescription(RssChannelImage rssChannelImage, Element element) throws RssGenerationException {
        String string = rssChannelImage.getImageDescription();
        this.validateValueOptional(string, "Image description", this.imageDescriptionMax);
        this.add(element, "description", string);
    }

    protected void handleImageHeight(RssChannelImage rssChannelImage, Element element) throws RssGenerationException {
        int n = rssChannelImage.getImageHeight();
        if (n > 400) {
            throw new RssGenerationException("Image height optional, value must be positive integer <= 400: " + n);
        }
        if (n != 0) {
            this.add(element, "height", String.valueOf(n));
        }
    }

    protected void handleImageWidth(RssChannelImage rssChannelImage, Element element) throws RssGenerationException {
        int n = rssChannelImage.getImageWidth();
        if (n > 144) {
            throw new RssGenerationException("Image width optional, value must be positive integer <= 144: " + n);
        }
        if (n != 0) {
            this.add(element, "width", String.valueOf(n));
        }
    }

    protected void handleItemDescription(RssChannelItem rssChannelItem, Element element) throws RssGenerationException {
        String string = rssChannelItem.getItemDescription();
        this.validateValueOptional(string, "Image description", this.itemDescriptionMax);
        this.add(element, "description", string);
    }
}

