/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.generator;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelImage;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssChannelTextInput;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.RssDublinCore;
import churchillobjects.rss4j.RssSyndication;
import churchillobjects.rss4j.generator.RssGenerationException;
import churchillobjects.rss4j.generator.RssGeneratorImpl091;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;

class RssGeneratorImpl100
extends RssGeneratorImpl091 {
    private static final String XMLNS_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String XMLNS = "http://purl.org/rss/1.0/";
    private static final String ROOT_ELEMENT = "RDF";
    private boolean usesSyndication = false;
    private boolean usesDublinCore = false;
    private Vector imageElements;
    private Vector itemElements;
    private Vector textInputElements;

    RssGeneratorImpl100() throws RssGenerationException {
    }

    protected void setMaxLengths() {
    }

    protected void createRssDocument(RssDocument rssDocument) {
        this.checkExtensions(rssDocument);
        this.imageElements = new Vector();
        this.itemElements = new Vector();
        this.textInputElements = new Vector();
        this.doc = this.domImpl.createDocument(XMLNS, ROOT_ELEMENT, null);
        this.rootElement = this.doc.getDocumentElement();
        this.rootElement.setPrefix("rdf");
        this.rootElement.setAttribute("xmlns:rdf", XMLNS_RDF);
        this.rootElement.setAttribute("xmlns", XMLNS);
        if (this.usesDublinCore) {
            this.rootElement.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        }
        if (this.usesSyndication) {
            this.rootElement.setAttribute("xmlns:sy", "http://purl.org/rss/1.0/modules/syndication/");
        }
    }

    protected void handleChannel(RssChannel rssChannel) throws RssGenerationException {
        Element element = this.doc.createElement("channel");
        this.rootElement.appendChild(element);
        String string = rssChannel.getChannelUri();
        if (string == null) {
            throw new RssGenerationException("The channel URI is required for RSS 1.0.");
        }
        this.validateUri(string);
        element.setAttribute("rdf:about", string);
        this.handleChannelTitle(rssChannel, element);
        this.handleChannelDescription(rssChannel, element);
        this.handleChannelLink(rssChannel, element);
        this.handleImage(rssChannel, element);
        this.handleItems(rssChannel, element);
        this.handleTextInput(rssChannel, element);
        this.handleDublinCore(rssChannel.getDublinCore(), element);
        this.handleSyndication(rssChannel, element);
    }

    protected void finishDocument() throws RssGenerationException {
        this.handleDocumentImages();
        this.handleDocumentItems();
        this.handleDocumentTextInputs();
    }

    protected void handleTextInput(RssChannel rssChannel, Element element) {
        RssChannelTextInput rssChannelTextInput = rssChannel.getChannelTextInput();
        if (rssChannelTextInput != null) {
            this.textInputElements.addElement(rssChannelTextInput);
            Element element2 = this.doc.createElement("textinput");
            element2.setAttribute("rdf:resource", rssChannelTextInput.getInputLink());
            element.appendChild(element2);
        }
    }

    protected void handleDocumentTextInputs() throws RssGenerationException {
        Enumeration enumeration = this.textInputElements.elements();
        while (enumeration.hasMoreElements()) {
            RssChannelTextInput rssChannelTextInput = (RssChannelTextInput)enumeration.nextElement();
            if (rssChannelTextInput == null) continue;
            Element element = this.doc.createElement("textinput");
            element.setAttribute("rdf:about", rssChannelTextInput.getInputLink());
            this.handleTextInputTitle(rssChannelTextInput, element);
            this.handleTextInputDescription(rssChannelTextInput, element);
            this.handleTextInputName(rssChannelTextInput, element);
            this.handleTextInputLink(rssChannelTextInput, element);
            this.handleDublinCore(rssChannelTextInput.getDublinCore(), element);
            this.rootElement.appendChild(element);
        }
    }

    protected void handleItems(RssChannel rssChannel, Element element) throws RssGenerationException {
        if (rssChannel.getItemCount() == 0) {
            throw new RssGenerationException("Each channel must have at least one item");
        }
        Enumeration enumeration = rssChannel.items();
        Element element2 = this.doc.createElement("items");
        element.appendChild(element2);
        Element element3 = this.doc.createElement("rdf:Seq");
        element2.appendChild(element3);
        while (enumeration.hasMoreElements()) {
            RssChannelItem rssChannelItem = (RssChannelItem)enumeration.nextElement();
            if (rssChannelItem == null) continue;
            this.itemElements.addElement(rssChannelItem);
            Element element4 = this.doc.createElement("rdf:li");
            element4.setAttribute("rdf:resource", rssChannelItem.getItemLink());
            element3.appendChild(element4);
        }
    }

    protected void handleDocumentItems() throws RssGenerationException {
        Enumeration enumeration = this.itemElements.elements();
        while (enumeration.hasMoreElements()) {
            RssChannelItem rssChannelItem = (RssChannelItem)enumeration.nextElement();
            if (rssChannelItem == null) continue;
            Element element = this.doc.createElement("item");
            element.setAttribute("rdf:about", rssChannelItem.getItemLink());
            this.handleItemTitle(rssChannelItem, element);
            this.handleItemLink(rssChannelItem, element);
            this.handleItemDescription(rssChannelItem, element);
            this.handleDublinCore(rssChannelItem.getDublinCore(), element);
            this.rootElement.appendChild(element);
        }
    }

    protected void handleImage(RssChannel rssChannel, Element element) {
        RssChannelImage rssChannelImage = rssChannel.getChannelImage();
        this.imageElements.addElement(rssChannelImage);
        if (rssChannelImage != null) {
            Element element2 = this.doc.createElement("image");
            element2.setAttribute("rdf:resource", rssChannelImage.getImageUrl());
            element.appendChild(element2);
        }
    }

    protected void handleDocumentImages() throws RssGenerationException {
        Enumeration enumeration = this.imageElements.elements();
        while (enumeration.hasMoreElements()) {
            RssChannelImage rssChannelImage = (RssChannelImage)enumeration.nextElement();
            if (rssChannelImage == null) continue;
            Element element = this.doc.createElement("image");
            element.setAttribute("rdf:about", rssChannelImage.getImageUrl());
            this.handleImageTitle(rssChannelImage, element);
            this.handleImageUrl(rssChannelImage, element);
            this.handleImageLink(rssChannelImage, element);
            this.handleDublinCore(rssChannelImage.getDublinCore(), element);
            this.rootElement.appendChild(element);
        }
    }

    protected void checkExtensions(RssDocument rssDocument) {
        Enumeration enumeration = rssDocument.channels();
        while (enumeration.hasMoreElements()) {
            RssChannel rssChannel = (RssChannel)enumeration.nextElement();
            if (rssChannel == null) continue;
            if (rssChannel.getChannelSyndication() != null) {
                this.usesSyndication = true;
            }
            if (rssChannel.getDublinCore() == null) continue;
            this.usesDublinCore = true;
        }
    }

    protected void handleSyndication(RssChannel rssChannel, Element element) throws RssGenerationException {
        RssSyndication rssSyndication = rssChannel.getChannelSyndication();
        if (rssSyndication != null) {
            if (rssSyndication.getUpdateBase() == null) {
                throw new RssGenerationException("An update base is required for syndication.");
            }
            this.add(element, "sy:updatePeriod", rssSyndication.getUpdatePeriod());
            this.add(element, "sy:updateFrequency", String.valueOf(rssSyndication.getUpdateFrequency()));
            this.add(element, "sy:updateBase", rssSyndication.getUpdateBase());
        }
    }

    protected void handleDublinCore(RssDublinCore rssDublinCore, Element element) {
        if (rssDublinCore != null) {
            this.add(element, "dc:title", rssDublinCore.getTitle());
            this.add(element, "dc:creator", rssDublinCore.getCreator());
            this.add(element, "dc:subject", rssDublinCore.getSubject());
            this.add(element, "dc:description", rssDublinCore.getDescription());
            this.add(element, "dc:publisher", rssDublinCore.getPublisher());
            this.add(element, "dc:contributor", rssDublinCore.getContributor());
            this.add(element, "dc:date", rssDublinCore.getDateAs8601());
            this.add(element, "dc:type", rssDublinCore.getType());
            this.add(element, "dc:format", rssDublinCore.getFormat());
            this.add(element, "dc:identifier", rssDublinCore.getIdentifier());
            this.add(element, "dc:source", rssDublinCore.getSource());
            this.add(element, "dc:language", rssDublinCore.getLanguage());
            this.add(element, "dc:relation", rssDublinCore.getRelation());
            this.add(element, "dc:coverage", rssDublinCore.getCoverage());
            this.add(element, "dc:rights", rssDublinCore.getRights());
        }
    }
}

