/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.parser;

import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.parser.RssParseException;
import churchillobjects.rss4j.parser.RssParserImpl090;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class RssParserImpl091
extends RssParserImpl090 {
    protected boolean inSkipDays = false;
    protected boolean inSkipHours = false;
    private static final String VERSION = "0.91";

    RssParserImpl091(RssDocument rssDocument, Vector vector) {
        super(rssDocument, vector);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        if ("skipDays".equals(string2)) {
            this.inSkipDays = true;
        }
        if ("skipHours".equals(string2)) {
            this.inSkipHours = true;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            super.endElement(string, string2, string3);
            if ("skipDays".equals(string2)) {
                this.inSkipDays = false;
            }
            if ("skipHours".equals(string2)) {
                this.inSkipHours = false;
            }
            if (!this.hasChars()) {
                return;
            }
            if ("day".equals(string2) && this.inSkipDays) {
                this.currentChannel.addSkipDay(this.getChars());
            }
            if ("hour".equals(string2) && this.inSkipHours) {
                this.handleHour();
            }
            if (this.inChannel && !this.inImage && !this.inItem && !this.inTextInput) {
                this.handleChannelAttributes(string2);
            }
            if (this.inImage) {
                this.handleImageAttributes(string2);
            }
            if (this.inItem && "description".equals(string2)) {
                this.currentItem.setItemDescription(this.getChars());
            }
            if (VERSION.equals(this.document.getVersion())) {
                this.resetChars();
                return;
            }
        }
        catch (RssParseException rssParseException) {
            throw new SAXException(rssParseException);
        }
    }

    private void handleHour() throws RssParseException {
        try {
            int n = Integer.parseInt(this.getChars());
            this.currentChannel.addSkipHour(n);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new RssParseException(numberFormatException);
        }
    }

    private void handleChannelAttributes(String string) {
        if ("language".equals(string)) {
            this.currentChannel.setChannelLanguage(this.getChars());
        }
        if ("rating".equals(string)) {
            this.currentChannel.setChannelPicsRating(this.getChars());
        }
        if ("copyright".equals(string)) {
            this.currentChannel.setChannelCopyright(this.getChars());
        }
        if ("pubDate".equals(string)) {
            this.currentChannel.setChannelPubDate(this.getChars());
        }
        if ("lastBuildDate".equals(string)) {
            this.currentChannel.setChannelLastBuildDate(this.getChars());
        }
        if ("docs".equals(string)) {
            this.currentChannel.setChannelDocs(this.getChars());
        }
        if ("managingEditor".equals(string)) {
            this.currentChannel.setChannelManagingEditor(this.getChars());
        }
        if ("webMaster".equals(string)) {
            this.currentChannel.setChannelWebmaster(this.getChars());
        }
    }

    private void handleImageAttributes(String string) throws RssParseException {
        int n;
        if ("width".equals(string)) {
            try {
                n = Integer.parseInt(this.getChars());
                this.currentImage.setImageWidth(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RssParseException(numberFormatException);
            }
        }
        if ("height".equals(string)) {
            try {
                n = Integer.parseInt(this.getChars());
                this.currentImage.setImageHeight(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RssParseException(numberFormatException);
            }
        }
        if ("description".equals(string)) {
            this.currentImage.setImageDescription(this.getChars());
        }
    }
}

