/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.parser;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelImage;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssChannelTextInput;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.RssDublinCore;
import churchillobjects.rss4j.RssSyndication;
import churchillobjects.rss4j.model.IUsesDublinCore;
import churchillobjects.rss4j.model.IUsesSyndication;
import churchillobjects.rss4j.model.RssNamespace;
import churchillobjects.rss4j.parser.RssParseException;
import churchillobjects.rss4j.parser.RssParserImpl090;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class RssParserImpl100
extends RssParserImpl090 {
    private static final String VERSION = "1.0";
    private Hashtable itemMappings = new Hashtable();
    private Hashtable imageMappings = new Hashtable();
    private Hashtable textInputMappings = new Hashtable();
    private Vector unmappedItems = new Vector();
    private Vector unmappedImages = new Vector();
    private Vector unmappedTextInputs = new Vector();
    private boolean inChannelItems = false;
    private boolean inChannelItemsSeq = false;

    RssParserImpl100(RssDocument rssDocument, Vector vector) {
        super(rssDocument, vector);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if ("channel".equals(string2)) {
                this.handleChannel(string, string2, string3, attributes);
            }
            if ("item".equals(string2) || "rdf:li".equals(string3)) {
                this.handleItem(string, string2, string3, attributes);
            }
            if ("textinput".equals(string2)) {
                this.handleTextInput(string, string2, string3, attributes);
            }
            if ("image".equals(string2)) {
                this.handleImage(string, string2, string3, attributes);
            }
            if ("items".equals(string3) && this.inChannel) {
                this.inChannelItems = true;
            }
            if ("rdf:Seq".equals(string3) && this.inChannel && this.inChannelItems) {
                this.inChannelItemsSeq = true;
                return;
            }
        }
        catch (RssParseException rssParseException) {
            throw new SAXException(rssParseException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if ("channel".equals(string3)) {
                this.currentChannel = null;
                this.inChannel = false;
            }
            if ("item".equals(string3) && !this.inChannel) {
                this.currentItem = null;
                this.inItem = false;
            }
            if ("textinput".equals(string3) && !this.inChannel) {
                this.currentTextInput = null;
                this.inTextInput = false;
            }
            if ("image".equals(string3) && !this.inChannel) {
                this.currentImage = null;
                this.inImage = false;
            }
            if ("items".equals(string3) && this.inChannel) {
                this.inChannelItems = false;
            }
            if ("rdf:Seq".equals(string3) && this.inChannel && this.inChannelItems) {
                this.inChannelItemsSeq = false;
            }
            if (!this.hasChars()) {
                return;
            }
            if (this.inChannel && !this.inImage && !this.inItem && !this.inTextInput) {
                this.addChannelAttribute(string2, string3);
            }
            if (this.inImage) {
                this.addImageAttribute(string2, string3);
            }
            if (this.inItem) {
                this.addItemAttribute(string2, string3);
            }
            if (this.inTextInput) {
                this.addTextInputAttribute(string2, string3);
            }
            this.resetChars();
            return;
        }
        catch (RssParseException rssParseException) {
            throw new SAXException(rssParseException);
        }
    }

    private void addTextInputAttribute(String string, String string2) throws RssParseException {
        String string3 = this.getChars();
        if ("title".equals(string2)) {
            this.currentTextInput.setInputTitle(string3);
        }
        if ("description".equals(string2)) {
            this.currentTextInput.setInputDescription(string3);
        }
        if ("name".equals(string2)) {
            this.currentTextInput.setInputName(string3);
        }
        if ("link".equals(string2)) {
            this.currentTextInput.setInputLink(string3);
        }
        if (string2.startsWith("dc:")) {
            this.handleDublinCore(this.currentTextInput, string, string3);
        }
    }

    private void addItemAttribute(String string, String string2) throws RssParseException {
        String string3 = this.getChars();
        if ("title".equals(string2)) {
            this.currentItem.setItemTitle(string3);
        }
        if ("link".equals(string2)) {
            this.currentItem.setItemLink(string3);
        }
        if ("description".equals(string2)) {
            this.currentItem.setItemDescription(string3);
        }
        if (string2.startsWith("dc:")) {
            this.handleDublinCore(this.currentItem, string, string3);
        }
    }

    private void addImageAttribute(String string, String string2) throws RssParseException {
        String string3 = this.getChars();
        if ("title".equals(string)) {
            this.currentImage.setImageTitle(string3);
        }
        if ("url".equals(string)) {
            this.currentImage.setImageUrl(string3);
        }
        if ("link".equals(string)) {
            this.currentImage.setImageLink(string3);
        }
        if (string2.startsWith("dc:")) {
            this.handleDublinCore(this.currentImage, string, string3);
        }
    }

    private void addChannelAttribute(String string, String string2) throws RssParseException {
        String string3 = this.getChars();
        if ("title".equals(string2)) {
            this.currentChannel.setChannelTitle(string3);
        }
        if ("link".equals(string2)) {
            this.currentChannel.setChannelLink(string3);
        }
        if ("description".equals(string2)) {
            this.currentChannel.setChannelDescription(string3);
        }
        if (string2.startsWith("sy:")) {
            this.handleSyndication(this.currentChannel, string, string3);
        }
        if (string2.startsWith("dc:")) {
            this.handleDublinCore(this.currentChannel, string, string3);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.checkForLeftovers();
            return;
        }
        catch (RssParseException rssParseException) {
            throw new SAXException(rssParseException);
        }
    }

    protected void handleChannel(String string, String string2, String string3, Attributes attributes) throws RssParseException {
        this.currentChannel = new RssChannel();
        String string4 = this.getAttributeUnqualified(string2, "about", "rdf", attributes);
        this.currentChannel.setChannelUri(string4);
        this.document.addChannel(this.currentChannel);
        this.inChannel = true;
    }

    protected void handleItem(String string, String string2, String string3, Attributes attributes) throws RssParseException {
        if ("item".equals(string2) && !this.inChannel) {
            String string4 = this.getAttributeUnqualified(string2, "about", "rdf", attributes);
            this.currentItem = (RssChannelItem)this.itemMappings.get(string4);
            if (this.currentItem == null) {
                this.document.addWarning("Encountered an <item> element under <rdf:RDF> that was not used in a preceding channel: " + string4);
                return;
            }
            this.unmappedItems.removeElement(string4);
            this.inItem = true;
            return;
        }
        if ("rdf:li".equals(string3) && this.inChannel && this.inChannelItems && this.inChannelItemsSeq) {
            String string5 = this.getAttributeUnqualified(string3, "resource", "rdf", attributes);
            RssChannelItem rssChannelItem = new RssChannelItem();
            this.currentChannel.addItem(rssChannelItem);
            this.itemMappings.put(string5, rssChannelItem);
            this.unmappedItems.addElement(string5);
        }
    }

    protected void handleTextInput(String string, String string2, String string3, Attributes attributes) throws RssParseException {
        if (this.inChannel) {
            RssChannelTextInput rssChannelTextInput = new RssChannelTextInput();
            String string4 = this.getAttributeUnqualified(string2, "resource", "rdf", attributes);
            this.textInputMappings.put(string4, rssChannelTextInput);
            this.unmappedTextInputs.addElement(string4);
            this.currentChannel.setChannelTextInput(rssChannelTextInput);
            return;
        }
        String string5 = this.getAttributeUnqualified(string2, "about", "rdf", attributes);
        this.currentTextInput = (RssChannelTextInput)this.textInputMappings.get(string5);
        if (this.currentTextInput == null) {
            this.document.addWarning("Encountered a <textinput> element under <rdf:RDF> that was not used in a preceding channel: " + string5);
            return;
        }
        this.unmappedTextInputs.removeElement(string5);
        this.inTextInput = true;
    }

    protected void handleImage(String string, String string2, String string3, Attributes attributes) throws RssParseException {
        if (this.inChannel) {
            RssChannelImage rssChannelImage = new RssChannelImage();
            String string4 = this.getAttributeUnqualified(string2, "resource", "rdf", attributes);
            this.imageMappings.put(string4, rssChannelImage);
            this.unmappedImages.addElement(string4);
            this.currentChannel.setChannelImage(rssChannelImage);
            return;
        }
        String string5 = this.getAttributeUnqualified(string2, "about", "rdf", attributes);
        this.currentImage = (RssChannelImage)this.imageMappings.get(string5);
        if (this.currentImage == null) {
            this.document.addWarning("Encountered an <image> element under <rdf:RDF> that was not used in a preceding channel: " + string5);
            return;
        }
        this.unmappedImages.removeElement(string5);
        this.inImage = true;
    }

    protected void handleSyndication(IUsesSyndication iUsesSyndication, String string, String string2) throws RssParseException {
        this.checkSyndication();
        RssSyndication rssSyndication = iUsesSyndication.getChannelSyndication();
        if (rssSyndication == null) {
            rssSyndication = new RssSyndication();
            iUsesSyndication.setChannelSyndication(rssSyndication);
        }
        if ("updatePeriod".equals(string)) {
            rssSyndication.setUpdatePeriod(string2);
        }
        if ("updateFrequency".equals(string)) {
            rssSyndication.setUpdateFrequency(Integer.parseInt(string2));
        }
        if ("updateBase".equals(string)) {
            try {
                rssSyndication.setUpdateBase(string2);
                return;
            }
            catch (ParseException parseException) {
                throw new RssParseException("Syndication update base date value not convertible from ISO8601: '" + string2 + "'");
            }
        }
    }

    protected void handleDublinCore(IUsesDublinCore iUsesDublinCore, String string, String string2) throws RssParseException {
        this.checkDublinCore();
        RssDublinCore rssDublinCore = iUsesDublinCore.getDublinCore();
        if (rssDublinCore == null) {
            rssDublinCore = new RssDublinCore();
            iUsesDublinCore.setDublinCore(rssDublinCore);
        }
        if ("title".equals(string)) {
            rssDublinCore.setTitle(string2);
        }
        if ("creator".equals(string)) {
            rssDublinCore.setCreator(string2);
        }
        if ("subject".equals(string)) {
            rssDublinCore.setSubject(string2);
        }
        if ("description".equals(string)) {
            rssDublinCore.setDescription(string2);
        }
        if ("publisher".equals(string)) {
            rssDublinCore.setPublisher(string2);
        }
        if ("contributor".equals(string)) {
            rssDublinCore.setContributor(string2);
        }
        if ("date".equals(string)) {
            try {
                rssDublinCore.setDate(string2);
            }
            catch (ParseException parseException) {
                throw new RssParseException("Dublin Core date value not convertible from ISO8601: '" + string2 + "'");
            }
        }
        if ("type".equals(string)) {
            rssDublinCore.setType(string2);
        }
        if ("format".equals(string)) {
            rssDublinCore.setFormat(string2);
        }
        if ("identifier".equals(string)) {
            rssDublinCore.setIdentifier(string2);
        }
        if ("source".equals(string)) {
            rssDublinCore.setSource(string2);
        }
        if ("language".equals(string)) {
            rssDublinCore.setLanguage(string2);
        }
        if ("relation".equals(string)) {
            rssDublinCore.setRelation(string2);
        }
        if ("coverage".equals(string)) {
            rssDublinCore.setCoverage(string2);
        }
        if ("rights".equals(string)) {
            rssDublinCore.setRights(string2);
        }
    }

    protected String getAttributeUnqualified(String string, String string2, String string3, Attributes attributes) throws RssParseException {
        String string4 = this.getAttribute(attributes, String.valueOf(string3) + ":" + string2);
        if (string4 == null) {
            string4 = this.getAttribute(attributes, string2);
            if (string4 != null) {
                this.document.addWarning(String.valueOf(string) + ": The use of unqualified attributes (such as '" + string2 + "' vs. '" + string3 + ":" + string2 + "') is deprecated.");
            } else {
                throw new RssParseException(String.valueOf(string3) + ":" + string2 + " attribute not present on the <" + string + "> element");
            }
        }
        return string4;
    }

    protected void checkDublinCore() throws RssParseException {
        Enumeration enumeration = this.namespaces.elements();
        while (enumeration.hasMoreElements()) {
            RssNamespace rssNamespace = (RssNamespace)enumeration.nextElement();
            if (rssNamespace == null || !"dc".equals(rssNamespace.getPrefix()) || !"http://purl.org/dc/elements/1.1/".equals(rssNamespace.getUri())) continue;
            return;
        }
        throw new RssParseException("Elements were found using Dublin Core but its namespace (xmlns:dc=\"http://purl.org/dc/elements/1.1/\") was not specified in the document header");
    }

    protected void checkSyndication() throws RssParseException {
        Enumeration enumeration = this.namespaces.elements();
        while (enumeration.hasMoreElements()) {
            RssNamespace rssNamespace = (RssNamespace)enumeration.nextElement();
            if (rssNamespace == null || !"sy".equals(rssNamespace.getPrefix()) || !"http://purl.org/rss/1.0/modules/syndication/".equals(rssNamespace.getUri())) continue;
            return;
        }
        throw new RssParseException("Elements were found using Syndication but its namespace (xmlns:sy=\"http://purl.org/rss/1.0/modules/syndication/\") was not specified in the document header");
    }

    private void checkForLeftovers() throws RssParseException {
        if (this.unmappedItems.size() > 0) {
            String string = (String)this.unmappedItems.elements().nextElement();
            throw new RssParseException("Item was found in channel but had no corresponding resource: '" + string + "'");
        }
        if (this.unmappedImages.size() > 0) {
            String string = (String)this.unmappedImages.elements().nextElement();
            throw new RssParseException("Image was found in channel but had no corresponding resource: '" + string + "'");
        }
        if (this.unmappedTextInputs.size() > 0) {
            String string = (String)this.unmappedTextInputs.elements().nextElement();
            throw new RssParseException("TextInput was found in channel but had no corresponding resource: '" + string + "'");
        }
    }
}

