/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.io.Serializable;
import java.text.ParseException;

public class Duration
implements Serializable {
    private static final boolean DEBUG = false;
    private static final int TIME_FLAG = 8;
    private short _year = 0;
    private short _month = 0;
    private short _day = 0;
    private short _hour = 0;
    private short _minute = 0;
    private short _second = 0;
    private short _millisecond = 0;
    private boolean _isNegative = false;

    public Duration() {
    }

    public Duration(String string) throws ParseException {
        this();
        Duration.parseDurationInternal(string, this);
    }

    public Duration(long l) {
        long l2 = 1000L;
        long l3 = 60L * l2;
        long l4 = 60L * l3;
        long l5 = 24L * l4;
        long l6 = (long)(30.42 * (double)l5);
        long l7 = 12L * l6;
        if (l < 0L) {
            this.setNegative();
            l = -l;
        }
        short s = (short)(l / l7);
        short s2 = (short)((l %= l7) / l6);
        short s3 = (short)((l %= l6) / l5);
        short s4 = (short)((l %= l5) / l4);
        short s5 = (short)((l %= l4) / l3);
        short s6 = (short)((l %= l3) / l2);
        short s7 = (short)(l %= l2);
        this.setValue(s, s2, s3, s4, s5, s6, s7);
    }

    public void setYear(short s) {
        this._year = s;
    }

    public void setMonth(short s) {
        this._month = s;
    }

    public void setDay(short s) {
        this._day = s;
    }

    public void setHour(short s) {
        this._hour = s;
    }

    public void setMinute(short s) {
        this._minute = s;
    }

    public void setSeconds(short s) {
        this._second = s;
    }

    public void setMilli(short s) {
        this._millisecond = s;
    }

    public void setNegative() {
        this._isNegative = true;
    }

    public void setValue(short s, short s2, short s3, short s4, short s5, short s6, short s7) {
        this.setYear(s);
        this.setMonth(s2);
        this.setDay(s3);
        this.setHour(s4);
        this.setMinute(s5);
        this.setSeconds(s6);
        this.setMilli(s7);
    }

    public short getYear() {
        return this._year;
    }

    public short getMonth() {
        return this._month;
    }

    public short getDay() {
        return this._day;
    }

    public short getHour() {
        return this._hour;
    }

    public short getMinute() {
        return this._minute;
    }

    public short getSeconds() {
        return this._second;
    }

    public short getMilli() {
        return this._millisecond;
    }

    public boolean isNegative() {
        return this._isNegative;
    }

    public long toLong() {
        long l = 0L;
        l = (long)((((((double)((long)this._year * 12L + (long)this._month) * 30.42 + (double)this._day) * 24.0 + (double)this._hour) * 60.0 + (double)this._minute) * 60.0 + (double)this._second) * 1000.0 + (double)this._millisecond);
        l = this.isNegative() ? -l : l;
        return l;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('P');
        if (this.toLong() == 0L) {
            stringBuffer.append("T0S");
        } else {
            boolean bl;
            if (this._year != 0) {
                stringBuffer.append(this._year);
                stringBuffer.append('Y');
            }
            if (this._month != 0) {
                stringBuffer.append(this._month);
                stringBuffer.append('M');
            }
            if (this._day != 0) {
                stringBuffer.append(this._day);
                stringBuffer.append('D');
            }
            boolean bl2 = bl = this._hour != 0 || this._minute != 0 || this._second != 0;
            if (bl) {
                stringBuffer.append('T');
                if (this._hour != 0) {
                    stringBuffer.append(this._hour);
                    stringBuffer.append('H');
                }
                if (this._minute != 0) {
                    stringBuffer.append(this._minute);
                    stringBuffer.append('M');
                }
                if (this._second != 0) {
                    stringBuffer.append(this._second);
                    if (this._millisecond != 0) {
                        stringBuffer.append('.');
                        if (this._millisecond < 100) {
                            stringBuffer.append('0');
                            if (this._millisecond < 10) {
                                stringBuffer.append('0');
                            }
                        }
                        stringBuffer.append(this._millisecond);
                    }
                    stringBuffer.append('S');
                }
            }
            if (this._isNegative) {
                stringBuffer.insert(0, '-');
            }
        }
        return stringBuffer.toString();
    }

    public static Object parse(String string) throws ParseException {
        return Duration.parseDuration(string);
    }

    public static Duration parseDuration(String string) throws ParseException {
        Duration duration = new Duration();
        return Duration.parseDurationInternal(string, duration);
    }

    private static Duration parseDurationInternal(String string, Duration duration) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException("the string to be parsed must not be null");
        }
        if (duration == null) {
            duration = new Duration();
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        if (cArray.length == 0) {
            return null;
        }
        if (cArray[n] == '-') {
            duration.setNegative();
            if (++n >= cArray.length) {
                throw new ParseException("'-' is wrong placed", 0);
            }
        }
        if (cArray[n] != 'P') {
            throw new ParseException("Missing 'P' delimiter", n);
        }
        if (++n == cArray.length) {
            throw new ParseException("Bad format for a duration:" + string, n);
        }
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (n < cArray.length) {
            char c = cArray[n++];
            switch (c) {
                case 'Y': {
                    String string2;
                    if (n3 > 0) {
                        string2 = string + ":Syntax error, 'Y' must " + "proceed all other delimiters.";
                        throw new ParseException(string2, n);
                    }
                    n3 = 64;
                    if (bl) {
                        duration.setYear((short)n2);
                        bl = false;
                        break;
                    }
                    string2 = string + ":missing number of years before 'Y'";
                    throw new ParseException(string2, n);
                }
                case 'M': {
                    String string2;
                    if ((n3 & 8) == 8) {
                        if ((n3 & 3) > 0) {
                            throw new ParseException(string + ": Syntax Error...", n);
                        }
                        n3 |= 2;
                        if (bl) {
                            duration.setMinute((short)n2);
                            bl = false;
                            break;
                        }
                        string2 = string + ": missing number of minutes " + "before 'M'";
                        throw new ParseException(string2, n);
                    }
                    if ((n3 & 0x3F) > 0) {
                        throw new ParseException(string + ":Syntax Error...", n);
                    }
                    n3 |= 0x20;
                    if (bl) {
                        duration.setMonth((short)n2);
                        bl = false;
                        break;
                    }
                    string2 = string + ":missing number of months before 'M'";
                    throw new ParseException(string2, n);
                }
                case 'D': {
                    if ((n3 & 0x1F) > 0) {
                        throw new ParseException(string + ":Syntax Error...", n);
                    }
                    n3 |= 0x10;
                    if (bl) {
                        duration.setDay((short)n2);
                        bl = false;
                        break;
                    }
                    String string2 = string + ":missing number of days before 'D'";
                    throw new ParseException(string2, n);
                }
                case 'T': {
                    String string2;
                    if ((n3 & 8) == 8) {
                        string2 = string + ":Syntax error, 'T' may not " + "exist more than once.";
                        throw new ParseException(string2, n);
                    }
                    n3 |= 8;
                    break;
                }
                case 'H': {
                    String string2;
                    if ((n3 & 0xF) != 8) {
                        string2 = null;
                        string2 = (n3 & 8) != 8 ? string + ": Missing 'T' before 'H'" : string + ": Syntax Error, 'H' must appear for 'M' or 'S'";
                        throw new ParseException(string2, n);
                    }
                    n3 |= 4;
                    if (bl) {
                        duration.setHour((short)n2);
                        bl = false;
                        break;
                    }
                    string2 = string + ":missing number of hours before 'H'";
                    throw new ParseException(string2, n);
                }
                case 'S': {
                    String string2;
                    if (n3 != 0) {
                        if ((n3 & 8) != 8) {
                            string2 = string + ": Missing 'T' before 'S'";
                            throw new ParseException(string2, n);
                        }
                        if ((n3 & 1) == 1) {
                            string2 = string + ": Syntax error 'S' may not exist more than once.";
                            throw new ParseException(string2, n);
                        }
                        n3 |= 1;
                        if (bl) {
                            duration.setSeconds((short)n2);
                            bl = false;
                            break;
                        }
                        string2 = string + ": missing number of seconds before 'S'";
                        throw new ParseException(string2, n);
                    }
                    if (bl) {
                        string2 = Integer.toString(n2);
                        if (string2.length() < 3) {
                            if (string2.length() < 2) {
                                n2 *= 10;
                            }
                            n2 *= 10;
                        }
                        duration.setMilli((short)n2);
                        bl = false;
                        break;
                    }
                    string2 = string + ": missing number of milliseconds before 'S'";
                    throw new ParseException(string2, n);
                }
                case '.': {
                    String string2;
                    if ((n3 | 1) == 1) {
                        string2 = string + ": Syntax error '.' may not exist more than once.";
                        throw new ParseException(string2, n);
                    }
                    if ((n3 & 8) != 8) {
                        string2 = string + ": Missing 'T' before 'S'";
                        throw new ParseException(string2, n);
                    }
                    n3 = 0;
                    if (bl) {
                        duration.setSeconds((short)n2);
                        bl = false;
                        break;
                    }
                    string2 = string + ": missing number of seconds before 'S'";
                    throw new ParseException(string2, n);
                }
                default: {
                    if ('0' <= c && c <= '9') {
                        if (bl) {
                            n2 = n2 * 10 + (c - 48);
                            break;
                        }
                        bl = true;
                        n2 = c - 48;
                        break;
                    }
                    throw new ParseException(string + ":Invalid character: " + c, n);
                }
            }
        }
        if ((n3 & 0xF) == 8) {
            System.out.println("Warning: " + string + ": T shall be omitted");
        }
        if (bl) {
            throw new ParseException(string + ": expecting ending delimiter", n);
        }
        return duration;
    }

    public int hashCode() {
        return this._year ^ this._month ^ this._day ^ this._hour ^ this._minute ^ this._second;
    }

    public boolean equals(Object object) {
        if (object instanceof Duration) {
            return this.equal((Duration)object);
        }
        return false;
    }

    public boolean equal(Duration duration) {
        boolean bl = false;
        if (duration == null) {
            return bl;
        }
        bl = this._year == duration.getYear();
        bl = bl && this._month == duration.getMonth();
        bl = bl && this._day == duration.getDay();
        bl = bl && this._hour == duration.getHour();
        bl = bl && this._minute == duration.getMinute();
        bl = bl && this._second == duration.getSeconds();
        bl = bl && this._millisecond == duration.getMilli();
        bl = bl && this.isNegative() == duration.isNegative();
        return bl;
    }

    public boolean isGreater(Duration duration) {
        boolean bl = false;
        bl = this.toLong() > duration.toLong();
        return bl;
    }
}

