/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.ElementUnmarshaller;
import org.exolab.castor.xml.schema.reader.ModelGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.WildcardUnmarshaller;

public class GroupUnmarshaller
extends ComponentReader {
    private static final int ALL = 1;
    private static final int CHOICE = 2;
    private static final int MODEL_GROUP = 3;
    private static final int SEQUENCE = 4;
    private static final String MAX_OCCURS_WILDCARD = "unbounded";
    private ComponentReader unmarshaller;
    private int depth = 0;
    private Group _group = null;
    private Schema _schema = null;
    private String _element = "sequence";
    private boolean foundAll = false;
    private boolean foundElement = false;
    private boolean foundGroup = false;
    private boolean foundModelGroup = false;
    private boolean foundAnnotation = false;

    public GroupUnmarshaller(Schema schema, String string, AttributeSet attributeSet, Resolver resolver) {
        this.setResolver(resolver);
        this._schema = schema;
        this._group = new Group();
        String string2 = null;
        if ("sequence".equals(string)) {
            this._group.setOrder(Order.seq);
        } else if ("choice".equals(string)) {
            this._group.setOrder(Order.choice);
        } else if ("all".equals(string)) {
            this.foundAll = true;
            this._group.setOrder(Order.all);
        } else {
            String string3 = "Invalid group element name: '" + string + "'";
            throw new IllegalArgumentException(string3);
        }
        this._element = string;
        string2 = attributeSet.getValue("name");
        if (string2 != null) {
            this._group.setName(string2);
        }
        if ((string2 = attributeSet.getValue("maxOccurs")) != null) {
            if (MAX_OCCURS_WILDCARD.equals(string2)) {
                this._group.setMaxOccurs(-1);
            } else {
                this._group.setMaxOccurs(ComponentReader.toInt(string2));
            }
        }
        if ((string2 = attributeSet.getValue("minOccurs")) != null) {
            this._group.setMinOccurs(ComponentReader.toInt(string2));
        }
        if (this._group.getOrder() == Order.all) {
            if (this._group.getMaxOccurs() != 1) {
                String string4 = "Wrong maxOccurs value for a <all>:" + this._group.getMaxOccurs();
                string4 = string4 + "\n1 is the only possible value.";
                throw new IllegalArgumentException(string4);
            }
            if (this._group.getMinOccurs() > 1) {
                String string5 = "Wrong minOccurs value for a <all>:" + this._group.getMinOccurs();
                string5 = string5 + "\n0 or 1 are the only possible values.";
                throw new IllegalArgumentException(string5);
            }
        }
        this._group.setId(attributeSet.getValue("id"));
    }

    public String elementName() {
        return this._element;
    }

    public Group getGroup() {
        return this._group;
    }

    public Object getObject() {
        return this.getGroup();
    }

    public void startElement(String string, String string2, AttributeSet attributeSet, Namespaces namespaces) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, string2, attributeSet, namespaces);
            ++this.depth;
            return;
        }
        if ("annotation".equals(string)) {
            if (this.foundElement || this.foundGroup || this.foundModelGroup) {
                this.error("An annotation may only appear as the first child of an element definition.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) 'annotation' is allowed as a child of element definitions.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeSet);
        } else if ("element".equals(string)) {
            this.foundElement = true;
            this.unmarshaller = new ElementUnmarshaller(this._schema, attributeSet, this.getResolver());
        } else if (string.equals("group")) {
            this.foundModelGroup = true;
            this.unmarshaller = new ModelGroupUnmarshaller(this._schema, attributeSet, this.getResolver());
        } else if (SchemaNames.isGroupName(string) && string != "group") {
            this.foundGroup = true;
            if ("all".equals(string)) {
                this.foundAll = true;
            }
            this.unmarshaller = new GroupUnmarshaller(this._schema, string, attributeSet, this.getResolver());
        } else if ("any".equals(string)) {
            if (this.foundAll) {
                this.error("<any> can not appear as a child of a <all> element");
            }
            this.unmarshaller = new WildcardUnmarshaller(this._group, this._schema, string, attributeSet, this.getResolver());
        } else {
            StringBuffer stringBuffer = new StringBuffer("illegal element <");
            stringBuffer.append(string);
            stringBuffer.append("> found in <group>.");
            throw new SchemaException(stringBuffer.toString());
        }
    }

    public void endElement(String string, String string2) throws XMLException {
        Structure structure;
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string, string2);
            --this.depth;
            return;
        }
        if (this.unmarshaller != null && !string.equals(this.unmarshaller.elementName())) {
            String string3 = "missing end element for ";
            string3 = string3 + this.unmarshaller.elementName();
            throw new SchemaException(string3);
        }
        this.unmarshaller.finish();
        if ("any".equals(string)) {
            structure = ((WildcardUnmarshaller)this.unmarshaller).getWildcard();
            try {
                this._group.addWildcard((Wildcard)structure);
            }
            catch (SchemaException schemaException) {
                throw new IllegalArgumentException(schemaException.getMessage());
            }
        }
        if ("annotation".equals(string)) {
            structure = (Annotation)this.unmarshaller.getObject();
            this._group.addAnnotation((Annotation)structure);
        } else if ("element".equals(string)) {
            structure = (ElementDecl)this.unmarshaller.getObject();
            this._group.addElementDecl((ElementDecl)structure);
        } else if (string.equals("group")) {
            structure = (ModelGroup)this.unmarshaller.getObject();
            this._group.addGroup((ModelGroup)structure);
        } else if (SchemaNames.isGroupName(string) && string != "group") {
            structure = ((GroupUnmarshaller)this.unmarshaller).getGroup();
            this._group.addGroup((Group)structure);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

