/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;
import org.exolab.castor.xml.schema.simpletypes.ListType;

public class SimpleTypeListUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private ListType _list = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;
    private boolean foundSimpleType = false;
    private boolean foundItemType = false;

    SimpleTypeListUnmarshaller(Schema schema, AttributeSet attributeSet) throws XMLException {
        this._schema = schema;
        this._list = new ListType(schema);
        String string = attributeSet.getValue("itemType");
        if (string != null && string.length() > 0) {
            this.foundItemType = true;
            XMLType xMLType = this._schema.getType(string);
            if (xMLType == null) {
                this._list.setItemType(string);
            } else {
                if (xMLType.getStructureType() == 6) {
                    String string2 = "The item type of a list cannot be a complexType.";
                    throw new IllegalStateException(string2);
                }
                this._list.setItemType((SimpleType)xMLType);
            }
        }
        this._list.setId(attributeSet.getValue("id"));
    }

    public String elementName() {
        return "list";
    }

    public void finish() throws XMLException {
        if (!this.foundItemType && !this.foundSimpleType) {
            String string = "Missing sub-component of <list>, either use  the 'itemType' attribute, or an anonymous simpleType.";
            this.error(string);
        }
    }

    public Object getObject() {
        if (!this.foundItemType && !this.foundSimpleType) {
            String string = "Missing sub-component of <list>, either use  the 'itemType' attribute, or an anonymous simpleType.";
            throw new IllegalStateException(string);
        }
        return this._list;
    }

    public void startElement(String string, String string2, AttributeSet attributeSet, Namespaces namespaces) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, string2, attributeSet, namespaces);
            ++this.depth;
            return;
        }
        if (string.equals("annotation")) {
            if (this.foundSimpleType) {
                this.error("An annotation must appear as the first child of 'list' elements.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of 'list' elements.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeSet);
        } else if ("simpleType".equals(string)) {
            if (this.foundItemType) {
                this.error("A 'list' element can have either an 'itemType' or  'simpleType'.");
            }
            if (this.foundSimpleType) {
                this.error("Only one (1) 'simpleType' may appear as a child of 'list' elements.");
            }
            this.foundSimpleType = true;
            this.unmarshaller = new SimpleTypeUnmarshaller(this._schema, attributeSet);
        } else {
            this.illegalElement(string);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String string, String string2) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string, string2);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(string)) {
            Annotation annotation = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._list.setLocalAnnotation(annotation);
        } else if ("simpleType".equals(string)) {
            SimpleType simpleType = (SimpleType)this.unmarshaller.getObject();
            this._list.setItemType(simpleType);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

