/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class CustomDateEditor
extends PropertyEditorSupport {
    private final DateFormat dateFormat;
    private final boolean allowEmpty;

    public CustomDateEditor(DateFormat dateFormat, boolean allowEmpty) {
        this.dateFormat = dateFormat;
        this.allowEmpty = allowEmpty;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allowEmpty && (text == null || "".equals(text.trim()))) {
            this.setValue(null);
        } else {
            try {
                this.setValue(this.dateFormat.parse(text));
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Could not parse date: " + ex.getMessage());
            }
        }
    }

    public String getAsText() {
        return this.dateFormat.format((Date)this.getValue());
    }
}

