/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JType;

public final class XSFloat
extends XSPatternBase {
    Float maxInclusive = null;
    Float maxExclusive = null;
    Float minInclusive = null;
    Float minExclusive = null;
    private static JType jType = JType.Float;

    public XSFloat() {
        this(SourceGenerator.usePrimitiveWrapper());
    }

    public XSFloat(boolean bl) {
        super((short)14);
        jType = bl ? new JClass("java.lang.Float") : JType.Float;
    }

    public JType getJType() {
        return jType;
    }

    public Float getMaxExclusive() {
        return this.maxExclusive;
    }

    public Float getMaxInclusive() {
        return this.maxInclusive;
    }

    public Float getMinExclusive() {
        return this.minExclusive;
    }

    public Float getMinInclusive() {
        return this.minInclusive;
    }

    public boolean hasMaximum() {
        return this.maxInclusive != null || this.maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this.minInclusive != null || this.minExclusive != null;
    }

    public void setMaxExclusive(float f) {
        this.maxExclusive = new Float(f);
    }

    public void setMaxExclusive(Float f) {
        this.maxExclusive = f;
    }

    public void setMaxInclusive(float f) {
        this.maxInclusive = new Float(f);
    }

    public void setMaxInclusive(Float f) {
        this.maxInclusive = f;
    }

    public void setMinExclusive(float f) {
        this.minExclusive = new Float(f);
    }

    public void setMinExclusive(Float f) {
        this.minExclusive = f;
    }

    public void setMinInclusive(float f) {
        this.minInclusive = new Float(f);
    }

    public void setMinInclusive(Float f) {
        this.minInclusive = f;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String string = facet.getName();
            if ("maxExclusive".equals(string)) {
                this.setMaxExclusive(facet.toFloat());
                continue;
            }
            if ("maxInclusive".equals(string)) {
                this.setMaxInclusive(facet.toFloat());
                continue;
            }
            if ("minExclusive".equals(string)) {
                this.setMinExclusive(facet.toFloat());
                continue;
            }
            if ("minInclusive".equals(string)) {
                this.setMinInclusive(facet.toFloat());
                continue;
            }
            if (!"pattern".equals(string)) continue;
            this.setPattern(facet.getValue());
        }
    }

    public String createToJavaObjectCode(String string) {
        if (SourceGenerator.usePrimitiveWrapper()) {
            return super.createToJavaObjectCode(string);
        }
        StringBuffer stringBuffer = new StringBuffer("new Float(");
        stringBuffer.append(string);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String createFromJavaObjectCode(String string) {
        StringBuffer stringBuffer = new StringBuffer("((Float)");
        stringBuffer.append(string);
        stringBuffer.append(").floatValue()");
        return stringBuffer.toString();
    }
}

