/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.WildcardUnmarshaller;

public class AttributeGroupUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private AttributeGroup _attributeGroup = null;
    private boolean allowAnnotation = true;
    private boolean foundAnyAttribute = false;
    private boolean isRef = false;
    private boolean requireName = false;
    private Schema _schema = null;

    /*
     * Enabled aggressive block sorting
     */
    public AttributeGroupUnmarshaller(Schema schema, AttributeSet attributeSet) throws XMLException {
        this._schema = schema;
        String string = attributeSet.getValue("ref");
        if (string == null) {
            AttributeGroupDecl attributeGroupDecl = new AttributeGroupDecl(schema);
            this._attributeGroup = attributeGroupDecl;
            attributeGroupDecl.setName(attributeSet.getValue("name"));
            attributeGroupDecl.setId(attributeSet.getValue("id"));
            return;
        }
        if (string.length() > 0) {
            this.isRef = true;
            this._attributeGroup = new AttributeGroupReference(schema, string);
            return;
        }
        String string2 = "The value of the 'ref' attribute for attribute group must contain a valid value.";
        throw new SchemaException(string2);
    }

    public String elementName() {
        return "attributeGroup";
    }

    public AttributeGroup getAttributeGroup() {
        return this._attributeGroup;
    }

    public Object getObject() {
        return this.getAttributeGroup();
    }

    public void startElement(String string, String string2, AttributeSet attributeSet, Namespaces namespaces) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, string2, attributeSet, namespaces);
            ++this.depth;
            return;
        }
        if ("anyAttribute".equals(string)) {
            if (this.foundAnyAttribute) {
                this.error("an anyAttribute element can appear only once as a child of an 'AttributeGroup'.");
            }
            this.foundAnyAttribute = true;
            this.allowAnnotation = true;
            this.unmarshaller = new WildcardUnmarshaller(this._attributeGroup, this._schema, string, attributeSet, this.getResolver());
        } else if ("attribute".equals(string)) {
            this.allowAnnotation = false;
            if (this.isRef) {
                this.error("AttributeGroup references may not have children.");
            }
            this.unmarshaller = new AttributeUnmarshaller(this._schema, attributeSet, this.getResolver());
        } else if ("attributeGroup".equals(string)) {
            this.allowAnnotation = false;
            if (this.isRef) {
                this.error("AttributeGroup references may not have children.");
            }
            this.unmarshaller = new AttributeGroupUnmarshaller(this._schema, attributeSet);
        } else if (string.equals("annotation")) {
            if (!this.allowAnnotation) {
                this.outOfOrder(string);
            }
            this.unmarshaller = new AnnotationUnmarshaller(attributeSet);
        } else {
            this.illegalElement(string);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String string, String string2) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string, string2);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("anyAttribute".equals(string)) {
            Wildcard wildcard = ((WildcardUnmarshaller)this.unmarshaller).getWildcard();
            try {
                ((AttributeGroupDecl)this._attributeGroup).setAnyAttribute(wildcard);
            }
            catch (SchemaException schemaException) {
                throw new IllegalArgumentException(schemaException.getMessage());
            }
        } else if ("attribute".equals(string)) {
            AttributeDecl attributeDecl = ((AttributeUnmarshaller)this.unmarshaller).getAttribute();
            ((AttributeGroupDecl)this._attributeGroup).addAttribute(attributeDecl);
        } else if ("attributeGroup".equals(string)) {
            Object object = this.unmarshaller.getObject();
            try {
                ((AttributeGroupDecl)this._attributeGroup).addReference((AttributeGroupReference)object);
            }
            catch (ClassCastException classCastException) {
                String string3 = "AttributeGroups cannot contain new AttributeGroup definitions, only references to top-level AttributeGroups are allowed.";
                this.error(string3);
            }
        } else if ("annotation".equals(string)) {
            Annotation annotation = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._attributeGroup.addAnnotation(annotation);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

