/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.quartz.JobDataMap;
import org.quartz.SchedulerException;

public class JobDetail
implements Cloneable,
Serializable {
    private String name;
    private String group;
    private String description;
    private Class jobClass;
    private JobDataMap jobDataMap;
    private boolean volatility = false;
    private boolean durability = false;
    private boolean shouldRecover = false;
    private ArrayList jobListeners = new ArrayList(2);
    static /* synthetic */ Class class$org$quartz$Job;
    static /* synthetic */ Class class$org$quartz$StatefulJob;

    public JobDetail() {
    }

    public JobDetail(String name, String group, Class jobClass) {
        this.setName(name);
        this.setGroup(group);
        this.setJobClass(jobClass);
    }

    public JobDetail(String name, String group, Class jobClass, boolean volatility, boolean durability, boolean recover) {
        this.setName(name);
        this.setGroup(group);
        this.setJobClass(jobClass);
        this.setVolatility(volatility);
        this.setDurability(durability);
        this.setRequestsRecovery(recover);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Job name cannot be empty.");
        }
        this.name = name;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        if (group == null || group.trim().length() == 0) {
            throw new IllegalArgumentException("Group name cannot be empty.");
        }
        this.group = group;
    }

    public String getFullName() {
        return this.group + "." + this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Class getJobClass() {
        return this.jobClass;
    }

    public void setJobClass(Class jobClass) {
        if (jobClass == null) {
            throw new IllegalArgumentException("Job class cannot be null.");
        }
        if (!(class$org$quartz$Job == null ? (class$org$quartz$Job = JobDetail.class$("org.quartz.Job")) : class$org$quartz$Job).isAssignableFrom(jobClass)) {
            throw new IllegalArgumentException("Job class must implement the Job interface.");
        }
        this.jobClass = jobClass;
    }

    public JobDataMap getJobDataMap() {
        if (this.jobDataMap == null) {
            this.jobDataMap = new JobDataMap();
        }
        return this.jobDataMap;
    }

    public void setJobDataMap(JobDataMap jobDataMap) {
        this.jobDataMap = jobDataMap;
    }

    public void validate() throws SchedulerException {
        if (this.name == null) {
            throw new SchedulerException("Job's name cannot be null", 100);
        }
        if (this.group == null) {
            throw new SchedulerException("Job's group cannot be null", 100);
        }
        if (this.jobClass == null) {
            throw new SchedulerException("Job's class cannot be null", 100);
        }
    }

    public void setVolatility(boolean volatility) {
        this.volatility = volatility;
    }

    public void setDurability(boolean durability) {
        this.durability = durability;
    }

    public void setRequestsRecovery(boolean shouldRecover) {
        this.shouldRecover = shouldRecover;
    }

    public boolean isVolatile() {
        return this.volatility;
    }

    public boolean isDurable() {
        return this.durability;
    }

    public boolean isStateful() {
        if (this.jobClass == null) {
            throw new IllegalStateException("Job Class is not yet set.");
        }
        return (class$org$quartz$StatefulJob == null ? (class$org$quartz$StatefulJob = JobDetail.class$("org.quartz.StatefulJob")) : class$org$quartz$StatefulJob).isAssignableFrom(this.jobClass);
    }

    public boolean requestsRecovery() {
        return this.shouldRecover;
    }

    public void addJobListener(String name) {
        this.jobListeners.add(name);
    }

    public boolean removeJobListener(String name) {
        return ((AbstractCollection)this.jobListeners).remove(name);
    }

    public String[] getJobListenerNames() {
        return this.jobListeners.toArray(new String[this.jobListeners.size()]);
    }

    public String toString() {
        return "JobDetail '" + this.getFullName() + "':  jobClass: '" + (this.getJobClass() == null ? null : this.getJobClass().getName()) + " isStateful: " + this.isStateful() + " isVolatile: " + this.isVolatile() + " isDurable: " + this.isDurable() + " requestsRecovers: " + this.requestsRecovery();
    }

    public Object clone() {
        JobDetail copy;
        try {
            copy = (JobDetail)super.clone();
            copy.jobListeners = (ArrayList)this.jobListeners.clone();
            if (this.jobDataMap != null) {
                copy.jobDataMap = (JobDataMap)this.jobDataMap.clone();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new IncompatibleClassChangeError("Not Cloneable.");
        }
        return copy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

