/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.zip;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.zip.ZipException;
import org.apache.commons.compress.zip.UnrecognizedExtraField;
import org.apache.commons.compress.zip.ZipExtraField;
import org.apache.commons.compress.zip.ZipShort;

public class ExtraFieldUtils {
    private static final Hashtable c_implementations = new Hashtable();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.compress.zip.AsiExtraField");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ExtraFieldUtils.register(clazz);
    }

    public static ZipExtraField createExtraField(ZipShort headerID) throws InstantiationException, IllegalAccessException {
        Class clazz = (Class)c_implementations.get(headerID);
        if (clazz != null) {
            return (ZipExtraField)clazz.newInstance();
        }
        UnrecognizedExtraField unrecognized = new UnrecognizedExtraField();
        unrecognized.setHeaderID(headerID);
        return unrecognized;
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] data) {
        int sum = 4 * data.length;
        int i = 0;
        while (i < data.length) {
            sum += data[i].getCentralDirectoryLength().getValue();
            ++i;
        }
        byte[] result = new byte[sum];
        int start = 0;
        int i2 = 0;
        while (i2 < data.length) {
            System.arraycopy(data[i2].getHeaderID().getBytes(), 0, result, start, 2);
            System.arraycopy(data[i2].getCentralDirectoryLength().getBytes(), 0, result, start + 2, 2);
            byte[] local = data[i2].getCentralDirectoryData();
            System.arraycopy(local, 0, result, start + 4, local.length);
            start += local.length + 4;
            ++i2;
        }
        return result;
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] data) {
        int sum = 4 * data.length;
        int i = 0;
        while (i < data.length) {
            sum += data[i].getLocalFileDataLength().getValue();
            ++i;
        }
        byte[] result = new byte[sum];
        int start = 0;
        int i2 = 0;
        while (i2 < data.length) {
            System.arraycopy(data[i2].getHeaderID().getBytes(), 0, result, start, 2);
            System.arraycopy(data[i2].getLocalFileDataLength().getBytes(), 0, result, start + 2, 2);
            byte[] local = data[i2].getLocalFileDataData();
            System.arraycopy(local, 0, result, start + 4, local.length);
            start += local.length + 4;
            ++i2;
        }
        return result;
    }

    public static ZipExtraField[] parse(byte[] data) throws ZipException {
        ArrayList<ZipExtraField> v = new ArrayList<ZipExtraField>();
        int start = 0;
        while (start <= data.length - 4) {
            ZipShort headerID = new ZipShort(data, start);
            int length = new ZipShort(data, start + 2).getValue();
            if (start + 4 + length > data.length) {
                throw new ZipException("data starting at " + start + " is in unknown format");
            }
            try {
                ZipExtraField ze = ExtraFieldUtils.createExtraField(headerID);
                ze.parseFromLocalFileData(data, start + 4, length);
                v.add(ze);
            }
            catch (InstantiationException ie) {
                throw new ZipException(ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new ZipException(iae.getMessage());
            }
            start += length + 4;
        }
        if (start != data.length) {
            throw new ZipException("data starting at " + start + " is in unknown format");
        }
        ZipExtraField[] result = new ZipExtraField[v.size()];
        return v.toArray(result);
    }

    public static void register(Class clazz) {
        try {
            ZipExtraField ze = (ZipExtraField)clazz.newInstance();
            c_implementations.put(ze.getHeaderID(), clazz);
        }
        catch (ClassCastException cc) {
            throw new RuntimeException(clazz + " doesn't implement ZipExtraField");
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(clazz + " is not a concrete class");
        }
        catch (IllegalAccessException ie) {
            throw new RuntimeException(clazz + "'s no-arg constructor is not public");
        }
    }
}

