/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.sql.CaseFragment;
import net.sf.hibernate.sql.DecodeCaseFragment;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.OracleJoinFragment;
import net.sf.hibernate.util.StringHelper;

public class SAPDBDialect
extends Dialect {
    public SAPDBDialect() {
        this.registerColumnType(-7, "BOOLEAN");
        this.registerColumnType(-5, "FIXED(19,0)");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(-6, "FIXED(3,0)");
        this.registerColumnType(4, "INT");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(12, "VARCHAR($l)");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(8, "DOUBLE PRECISION");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(-3, "LONG BYTE");
        this.registerColumnType(2, "FIXED(19,$l)");
        this.registerColumnType(2005, "LONG VARCHAR");
        this.registerColumnType(2004, "LONG BYTE");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    public boolean supportsForUpdate() {
        return true;
    }

    public boolean dropConstraints() {
        return false;
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey) {
        return new StringBuffer(30).append(" foreign key ").append(constraintName).append(" (").append(StringHelper.join(", ", foreignKey)).append(") references ").append(referencedTable).toString();
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " primary key ";
    }

    public String getNullColumnString() {
        return " null";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getQuerySequencesString() {
        return "select SEQUENCE_NAME from DOMAIN.SEQUENCES";
    }

    public JoinFragment createOuterJoinFragment() {
        return new OracleJoinFragment();
    }

    public boolean supportsSequences() {
        return true;
    }

    public CaseFragment createCaseFragment() {
        return new DecodeCaseFragment();
    }
}

