/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.FetchMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Order;
import net.sf.hibernate.impl.AbstractQueryImpl;
import net.sf.hibernate.impl.SessionImpl;
import net.sf.hibernate.persister.PropertyMapping;
import net.sf.hibernate.transform.AliasToEntityMapResultTransformer;
import net.sf.hibernate.transform.ResultTransformer;
import net.sf.hibernate.transform.RootEntityResultTransformer;
import net.sf.hibernate.type.AssociationType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.StringHelper;

public class CriteriaImpl
implements Criteria {
    private List criteria = new ArrayList();
    private List orderings = new ArrayList();
    private Map fetchModes = new HashMap();
    private Map associationPathByAlias = new HashMap();
    private Map aliasByAssociationPath = new HashMap();
    private Map classByAlias = new HashMap();
    private Map lockModes = new HashMap();
    private Integer maxResults;
    private Integer firstResult;
    private Integer timeout;
    private Class persistentClass;
    private SessionImpl session;
    private ResultTransformer resultTransformer = new RootEntityResultTransformer();
    private boolean cacheable;
    private String cacheRegion;
    private int counter = 0;

    private String generateAlias() {
        return "x" + this.counter++ + '_';
    }

    public Criteria setMaxResults(int maxResults) {
        this.maxResults = new Integer(maxResults);
        return this;
    }

    public Criteria setFirstResult(int firstResult) {
        this.firstResult = new Integer(firstResult);
        return this;
    }

    public Criteria setTimeout(int timeout) {
        this.timeout = new Integer(timeout);
        return this;
    }

    public Criteria add(Criterion expression) {
        this.add("this", expression);
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public Integer getFirstResult() {
        return this.firstResult;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public CriteriaImpl(Class persistentClass, SessionImpl session) {
        this.persistentClass = persistentClass;
        this.session = session;
        this.classByAlias.put("this", persistentClass);
        this.cacheable = false;
    }

    public CriteriaImpl(Class persistentClass, CriteriaImpl original) {
        this.persistentClass = persistentClass;
        this.classByAlias = original.classByAlias;
        this.classByAlias.put("this", persistentClass);
        this.criteria = original.criteria;
        this.orderings = original.orderings;
        this.fetchModes = original.fetchModes;
        this.associationPathByAlias = original.associationPathByAlias;
        this.aliasByAssociationPath = original.aliasByAssociationPath;
        this.lockModes = original.lockModes;
        this.maxResults = original.maxResults;
        this.firstResult = original.firstResult;
        this.timeout = original.timeout;
        this.session = original.session;
        this.resultTransformer = original.resultTransformer;
        this.counter = original.counter;
        this.cacheable = original.cacheable;
        this.cacheRegion = original.cacheRegion;
    }

    public List list() throws HibernateException {
        return this.session.find(this);
    }

    public Iterator iterateExpressionEntries() {
        return this.criteria.iterator();
    }

    public Iterator iterateOrderings() {
        return this.orderings.iterator();
    }

    public Class getPersistentClass(String alias) {
        return (Class)this.classByAlias.get(alias);
    }

    public Map getAliasClasses() {
        return this.classByAlias;
    }

    public String toString() {
        return this.criteria.toString();
    }

    public Criteria addOrder(Order ordering) {
        this.orderings.add(ordering);
        return this;
    }

    public FetchMode getFetchMode(String path) {
        return (FetchMode)this.fetchModes.get(path);
    }

    public Criteria setFetchMode(String associationPath, FetchMode mode) {
        this.fetchModes.put(associationPath, mode);
        return this;
    }

    public Criteria createAlias(String associationPath, String alias) throws HibernateException {
        this.createAlias("this", associationPath, alias);
        return this;
    }

    private void createAlias(String rootAlias, String associationPath, String alias) throws HibernateException {
        String wholeAssociationPath;
        String rootPath;
        String testAlias = StringHelper.root(associationPath);
        if (this.classByAlias.containsKey(testAlias)) {
            rootAlias = testAlias;
            associationPath = associationPath.substring(rootAlias.length() + 1);
        }
        if ((rootPath = (String)this.associationPathByAlias.get(rootAlias)) == null) {
            if (!"this".equals(rootAlias)) {
                throw new HibernateException("unknown alias: " + rootAlias);
            }
            wholeAssociationPath = associationPath;
        } else {
            wholeAssociationPath = StringHelper.qualify(rootPath, associationPath);
        }
        this.associationPathByAlias.put(alias, wholeAssociationPath);
        this.aliasByAssociationPath.put(wholeAssociationPath, alias);
        this.classByAlias.put(alias, this.getClassForPath(rootAlias, associationPath));
    }

    public boolean isJoin(String path) {
        return this.aliasByAssociationPath.containsKey(path);
    }

    public String getAlias(String associationPath) {
        return (String)this.aliasByAssociationPath.get(associationPath);
    }

    public Criteria add(String alias, Criterion expression) {
        this.criteria.add(new CriterionEntry(expression, alias));
        return this;
    }

    public Class getClassForPath(String rootAlias, String associationPath) throws HibernateException {
        Class clazz;
        SessionFactoryImplementor factory = this.session.getFactory();
        Type type = ((PropertyMapping)((Object)factory.getPersister(clazz = (Class)this.classByAlias.get(rootAlias)))).toType(associationPath);
        if (!type.isAssociationType()) {
            throw new QueryException("not an association path: " + associationPath);
        }
        return ((AssociationType)type).getAssociatedClass(factory);
    }

    public Criteria createCriteria(String associationPath) throws HibernateException {
        return this.createCriteriaAt("this", associationPath);
    }

    private Criteria createCriteriaAt(String rootAlias, String associationPath) throws HibernateException {
        return this.createCriteriaAt(rootAlias, associationPath, this.generateAlias());
    }

    private Criteria createCriteriaAt(String rootAlias, String associationPath, String alias) throws HibernateException {
        String testAlias = StringHelper.root(associationPath);
        if (this.classByAlias.containsKey(testAlias)) {
            rootAlias = testAlias;
            associationPath = associationPath.substring(rootAlias.length() + 1);
        }
        this.createAlias(rootAlias, associationPath, alias);
        return new Subcriteria(alias, associationPath);
    }

    public Object uniqueResult() throws HibernateException {
        return AbstractQueryImpl.uniqueElement(this.list());
    }

    public Class getCriteriaClass() {
        return this.persistentClass;
    }

    public Class getCriteriaClass(String alias) {
        return (Class)this.classByAlias.get(alias);
    }

    public Criteria createCriteria(String associationPath, String alias) throws HibernateException {
        return this.createCriteriaAt("this", associationPath, alias);
    }

    public Criteria returnMaps() {
        this.setResultTransformer(new AliasToEntityMapResultTransformer());
        return this;
    }

    public Criteria returnRootEntities() {
        this.setResultTransformer(new RootEntityResultTransformer());
        return this;
    }

    public Criteria setLockMode(LockMode lockMode) {
        return this.setLockMode("this", lockMode);
    }

    public Criteria setLockMode(String alias, LockMode lockMode) {
        this.lockModes.put(alias, lockMode);
        return this;
    }

    public Map getLockModes() {
        return this.lockModes;
    }

    public ResultTransformer getResultTransformer() {
        return this.resultTransformer;
    }

    public Criteria setResultTransformer(ResultTransformer tupleMapper) {
        this.resultTransformer = tupleMapper;
        return this;
    }

    public boolean getCacheable() {
        return this.cacheable;
    }

    public String getCacheRegion() {
        return this.cacheRegion;
    }

    public Criteria setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public Criteria setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion.trim();
        return this;
    }

    public static final class CriterionEntry {
        private final Criterion criterion;
        private final String alias;

        private CriterionEntry(Criterion criterion, String alias) {
            this.alias = alias;
            this.criterion = criterion;
        }

        public Criterion getCriterion() {
            return this.criterion;
        }

        public String getAlias() {
            return this.alias;
        }
    }

    public final class Subcriteria
    implements Criteria {
        private String rootAlias;
        private String rootPath;

        private Subcriteria(String rootAlias, String rootPath) {
            this.rootAlias = rootAlias;
            this.rootPath = rootPath;
        }

        public Criteria add(Criterion expression) {
            CriteriaImpl.this.add(this.rootAlias, expression);
            return this;
        }

        public Criteria createAlias(String associationPath, String alias) throws HibernateException {
            CriteriaImpl.this.createAlias(this.rootAlias, associationPath, alias);
            return this;
        }

        public Criteria addOrder(Order order) {
            throw new UnsupportedOperationException("subcriteria cannot be ordered");
        }

        public Criteria createCriteria(String associationPath) throws HibernateException {
            return CriteriaImpl.this.createCriteriaAt(this.rootAlias, associationPath);
        }

        public List list() throws HibernateException {
            return CriteriaImpl.this.list();
        }

        public Object uniqueResult() throws HibernateException {
            return CriteriaImpl.this.uniqueResult();
        }

        public Criteria setFetchMode(String associationPath, FetchMode mode) throws HibernateException {
            CriteriaImpl.this.setFetchMode(StringHelper.qualify(this.rootPath, associationPath), mode);
            return this;
        }

        public Criteria setFirstResult(int firstResult) {
            CriteriaImpl.this.setFirstResult(firstResult);
            return this;
        }

        public Criteria setMaxResults(int maxResults) {
            CriteriaImpl.this.setMaxResults(maxResults);
            return this;
        }

        public Criteria setTimeout(int timeout) {
            CriteriaImpl.this.setTimeout(timeout);
            return this;
        }

        public Class getCriteriaClass() {
            return CriteriaImpl.this.getCriteriaClass(this.rootAlias);
        }

        public Class getCriteriaClass(String alias) {
            return CriteriaImpl.this.getCriteriaClass(alias);
        }

        public Criteria createCriteria(String associationPath, String alias) throws HibernateException {
            return CriteriaImpl.this.createCriteriaAt(this.rootAlias, associationPath, alias);
        }

        public Criteria returnMaps() {
            CriteriaImpl.this.returnMaps();
            return this;
        }

        public Criteria returnRootEntities() {
            CriteriaImpl.this.returnRootEntities();
            return this;
        }

        public Criteria setLockMode(LockMode lockMode) {
            CriteriaImpl.this.setLockMode(this.rootAlias, lockMode);
            return this;
        }

        public Criteria setLockMode(String alias, LockMode lockMode) {
            CriteriaImpl.this.setLockMode(alias, lockMode);
            return this;
        }

        public Criteria setResultTransformer(ResultTransformer resultProcessor) {
            CriteriaImpl.this.setResultTransformer(resultProcessor);
            return this;
        }

        public Criteria setCacheable(boolean cacheable) {
            CriteriaImpl.this.setCacheable(cacheable);
            return this;
        }

        public Criteria setCacheRegion(String cacheRegion) {
            CriteriaImpl.this.setCacheRegion(cacheRegion);
            return this;
        }
    }
}

