/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.ObjectDeletedException;
import net.sf.hibernate.ObjectNotFoundException;
import net.sf.hibernate.PersistentObjectException;
import net.sf.hibernate.Query;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.StaleObjectStateException;
import net.sf.hibernate.TransientObjectException;
import net.sf.hibernate.UnresolvableObjectException;
import net.sf.hibernate.WrongClassException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate.HibernateJdbcException;
import org.springframework.orm.hibernate.HibernateObjectRetrievalFailureException;
import org.springframework.orm.hibernate.HibernateOptimisticLockingFailureException;
import org.springframework.orm.hibernate.HibernateQueryException;
import org.springframework.orm.hibernate.HibernateSystemException;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class SessionFactoryUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$orm$hibernate$SessionFactoryUtils == null ? (class$org$springframework$orm$hibernate$SessionFactoryUtils = SessionFactoryUtils.class$("org.springframework.orm.hibernate.SessionFactoryUtils")) : class$org$springframework$orm$hibernate$SessionFactoryUtils));
    static /* synthetic */ Class class$org$springframework$orm$hibernate$SessionFactoryUtils;

    public static Session getSession(SessionFactory sessionFactory, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        if (!TransactionSynchronizationManager.hasResource((Object)sessionFactory) && !allowCreate) {
            throw new IllegalStateException("No Hibernate Session bound to thread, and configuration does not allow creation of new one here");
        }
        return SessionFactoryUtils.getSession(sessionFactory, null, null, true);
    }

    public static Session getSession(SessionFactory sessionFactory, Interceptor entityInterceptor, SQLExceptionTranslator jdbcExceptionTranslator) {
        return SessionFactoryUtils.getSession(sessionFactory, entityInterceptor, jdbcExceptionTranslator, true);
    }

    public static Session getSession(SessionFactory sessionFactory, Interceptor entityInterceptor, SQLExceptionTranslator jdbcExceptionTranslator, boolean allowSynchronization) throws DataAccessResourceFailureException {
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder != null) {
            if (allowSynchronization && TransactionSynchronizationManager.isSynchronizationActive() && !sessionHolder.isSynchronizedWithTransaction()) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, sessionFactory, jdbcExceptionTranslator, false));
                sessionHolder.setSynchronizedWithTransaction(true);
            }
            return sessionHolder.getSession();
        }
        try {
            Session session;
            logger.debug((Object)"Opening Hibernate session");
            Session session2 = session = entityInterceptor != null ? sessionFactory.openSession(entityInterceptor) : sessionFactory.openSession();
            if (allowSynchronization) {
                TransactionManager jtaTm;
                if (TransactionSynchronizationManager.isSynchronizationActive()) {
                    logger.debug((Object)"Registering Spring transaction synchronization for Hibernate session");
                    sessionHolder = new SessionHolder(session);
                    sessionHolder.setSynchronizedWithTransaction(true);
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, sessionFactory, jdbcExceptionTranslator, true));
                    TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
                } else if (sessionFactory instanceof SessionFactoryImplementor && (jtaTm = ((SessionFactoryImplementor)sessionFactory).getTransactionManager()) != null) {
                    try {
                        if (jtaTm.getStatus() == 0 || jtaTm.getStatus() == 1) {
                            logger.debug((Object)"Registering JTA transaction synchronization for Hibernate session");
                            sessionHolder = new SessionHolder(session);
                            sessionHolder.setSynchronizedWithTransaction(true);
                            jtaTm.getTransaction().registerSynchronization((Synchronization)new JtaSessionSynchronization(new SpringSessionSynchronization(sessionHolder, sessionFactory, jdbcExceptionTranslator, true), jtaTm));
                            TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
                        }
                    }
                    catch (Exception ex) {
                        throw new DataAccessResourceFailureException("Could not register synchronization with JTA TransactionManager", (Throwable)ex);
                    }
                }
            }
            return session;
        }
        catch (JDBCException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate session", (Throwable)ex.getSQLException());
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate session", (Throwable)ex);
        }
    }

    public static void applyTransactionTimeout(Query query, SessionFactory sessionFactory) {
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder != null && sessionHolder.getDeadline() != null) {
            query.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public static void applyTransactionTimeout(Criteria criteria, SessionFactory sessionFactory) {
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder != null && sessionHolder.getDeadline() != null) {
            criteria.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public static DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCException) {
            return new HibernateJdbcException((JDBCException)((Object)ex));
        }
        if (ex instanceof UnresolvableObjectException) {
            return new HibernateObjectRetrievalFailureException((UnresolvableObjectException)ex);
        }
        if (ex instanceof ObjectNotFoundException) {
            return new HibernateObjectRetrievalFailureException((ObjectNotFoundException)ex);
        }
        if (ex instanceof ObjectDeletedException) {
            return new HibernateObjectRetrievalFailureException((ObjectDeletedException)ex);
        }
        if (ex instanceof WrongClassException) {
            return new HibernateObjectRetrievalFailureException((WrongClassException)ex);
        }
        if (ex instanceof StaleObjectStateException) {
            return new HibernateOptimisticLockingFailureException((StaleObjectStateException)ex);
        }
        if (ex instanceof QueryException) {
            return new HibernateQueryException((QueryException)ex);
        }
        if (ex instanceof PersistentObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage());
        }
        if (ex instanceof TransientObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage());
        }
        return new HibernateSystemException(ex);
    }

    public static void closeSessionIfNecessary(Session session, SessionFactory sessionFactory) throws CleanupFailureDataAccessException {
        if (session == null || TransactionSynchronizationManager.hasResource((Object)sessionFactory)) {
            return;
        }
        logger.debug((Object)"Closing Hibernate session");
        try {
            session.close();
        }
        catch (JDBCException ex) {
            throw new CleanupFailureDataAccessException("Could not close Hibernate session", (Throwable)ex.getSQLException());
        }
        catch (HibernateException ex) {
            throw new CleanupFailureDataAccessException("Could not close Hibernate session", (Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class JtaSessionSynchronization
    implements Synchronization {
        private final SpringSessionSynchronization springSessionSynchronization;
        private final TransactionManager jtaTransactionManager;

        private JtaSessionSynchronization(SpringSessionSynchronization springSessionSynchronization, TransactionManager jtaTransactionManager) {
            this.springSessionSynchronization = springSessionSynchronization;
            this.jtaTransactionManager = jtaTransactionManager;
        }

        public void beforeCompletion() {
            try {
                this.springSessionSynchronization.beforeCommit(false);
            }
            catch (Throwable ex) {
                logger.error((Object)"beforeCommit callback threw exception", ex);
                try {
                    this.jtaTransactionManager.setRollbackOnly();
                }
                catch (SystemException ex2) {
                    logger.error((Object)"Could not set JTA transaction rollback-only", (Throwable)ex2);
                }
            }
        }

        public void afterCompletion(int status) {
            this.springSessionSynchronization.beforeCompletion();
            this.springSessionSynchronization.afterCompletion(-1);
        }
    }

    private static class SpringSessionSynchronization
    implements TransactionSynchronization {
        private final SessionHolder sessionHolder;
        private final SessionFactory sessionFactory;
        private final SQLExceptionTranslator jdbcExceptionTranslator;
        private final boolean newSession;
        private boolean hibernateTransactionCompletion;

        private SpringSessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator, boolean newSession) {
            this.sessionHolder = sessionHolder;
            this.sessionFactory = sessionFactory;
            this.jdbcExceptionTranslator = jdbcExceptionTranslator;
            this.hibernateTransactionCompletion = sessionFactory instanceof SessionFactoryImplementor && ((SessionFactoryImplementor)sessionFactory).getTransactionManager() != null;
            this.newSession = newSession;
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.sessionHolder));
        }

        public void beforeCommit(boolean readOnly) throws DataAccessException {
            if (!readOnly && !this.sessionHolder.getSession().getFlushMode().equals(FlushMode.NEVER)) {
                logger.debug((Object)"Flushing Hibernate session on transaction synchronization");
                try {
                    this.sessionHolder.getSession().flush();
                }
                catch (JDBCException ex) {
                    if (this.jdbcExceptionTranslator != null) {
                        throw this.jdbcExceptionTranslator.translate("SessionSynchronization", null, ex.getSQLException());
                    }
                    throw new HibernateJdbcException(ex);
                }
                catch (HibernateException ex) {
                    throw SessionFactoryUtils.convertHibernateAccessException(ex);
                }
            }
        }

        public void beforeCompletion() throws CleanupFailureDataAccessException {
            if (this.newSession) {
                TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                if (this.hibernateTransactionCompletion) {
                    SessionFactoryUtils.closeSessionIfNecessary(this.sessionHolder.getSession(), this.sessionFactory);
                }
            }
        }

        public void afterCompletion(int status) {
            if (!this.hibernateTransactionCompletion) {
                Session session = this.sessionHolder.getSession();
                if (session instanceof SessionImplementor) {
                    ((SessionImplementor)session).afterTransactionCompletion(status == 0);
                }
                if (this.newSession) {
                    SessionFactoryUtils.closeSessionIfNecessary(session, this.sessionFactory);
                }
            }
            this.sessionHolder.setSynchronizedWithTransaction(false);
        }
    }
}

