/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate.support;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.UserType;
import net.sf.hibernate.util.EqualsHelper;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate.LocalSessionFactoryBean;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class ClobStringType
implements UserType {
    protected final LobHandler lobHandler = LocalSessionFactoryBean.getConfigTimeLobHandler();
    static /* synthetic */ Class class$java$lang$String;

    public int[] sqlTypes() {
        return new int[]{2005};
    }

    public Class returnedClass() {
        return class$java$lang$String == null ? (class$java$lang$String = ClobStringType.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean equals(Object x, Object y) {
        return EqualsHelper.equals((Object)x, (Object)y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws SQLException {
        if (this.lobHandler == null) {
            throw new IllegalStateException("No LobHandler found for configuration - lobHandler property must be set on LocalSessionFactoryBean");
        }
        return this.lobHandler.getClobAsString(rs, rs.findColumn(names[0]));
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws SQLException {
        if (this.lobHandler == null) {
            throw new IllegalStateException("No LobHandler found for configuration - lobHandler property must be set on LocalSessionFactoryBean");
        }
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("ClobStringType requires active transaction synchronization");
        }
        LobCreator lobCreator = this.lobHandler.getLobCreator();
        lobCreator.setClobAsString(st, index, (String)value);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new LobCreatorSynchronization(lobCreator));
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LobCreatorSynchronization
    extends TransactionSynchronizationAdapter {
        private final LobCreator lobCreator;

        private LobCreatorSynchronization(LobCreator lobCreator) {
            this.lobCreator = lobCreator;
        }

        public void beforeCompletion() {
            this.lobCreator.close();
        }
    }
}

