/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.commons;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.DefaultFileItem;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.multipart.MultipartFile;

public class CommonsMultipartFile
implements MultipartFile {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final FileItem fileItem;

    protected CommonsMultipartFile(FileItem fileItem) {
        this.fileItem = fileItem;
    }

    public FileItem getFileItem() {
        return this.fileItem;
    }

    public String getName() {
        return this.fileItem.getFieldName();
    }

    public boolean isEmpty() {
        return this.fileItem.getName() == null || this.fileItem.getName().length() == 0;
    }

    public String getOriginalFilename() {
        return !this.isEmpty() ? new File(this.fileItem.getName()).getName() : null;
    }

    public String getContentType() {
        return !this.isEmpty() ? this.fileItem.getContentType() : null;
    }

    public long getSize() {
        return this.fileItem.getSize();
    }

    public byte[] getBytes() {
        return this.fileItem.get();
    }

    public InputStream getInputStream() throws IOException {
        return this.fileItem.getInputStream();
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        if (dest.exists() && !dest.delete()) {
            throw new IOException("Destination file [" + dest.getAbsolutePath() + "] already exists and could not be deleted");
        }
        try {
            this.fileItem.write(dest);
            if (this.logger.isDebugEnabled()) {
                String action = "transferred";
                if (this.fileItem instanceof DefaultFileItem) {
                    action = ((DefaultFileItem)this.fileItem).getStoreLocation().exists() ? "copied" : "moved";
                }
                this.logger.debug((Object)("Multipart file [" + this.getName() + "] with original file name [" + this.getOriginalFilename() + "], stored " + this.getStorageDescription() + ": " + action + " to [" + dest.getAbsolutePath() + "]"));
            }
        }
        catch (FileUploadException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.logger.error((Object)"Could not transfer to file", (Throwable)ex);
            throw new IOException("Could not transfer to file: " + ex.getMessage());
        }
    }

    protected String getStorageDescription() {
        if (this.fileItem.isInMemory()) {
            return "in memory";
        }
        if (this.fileItem instanceof DefaultFileItem) {
            return "at [" + ((DefaultFileItem)this.fileItem).getStoreLocation().getAbsolutePath() + "]";
        }
        return "at disk";
    }
}

