/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AnyType;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.BlockList;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.FinalList;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.SimpleTypesFactory;
import org.exolab.castor.xml.schema.XMLType;

public class Schema
extends Annotated {
    public static final String DEFAULT_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String NULL_ARGUMENT = "A null argument was passed to " + (class$org$exolab$castor$xml$schema$Schema == null ? (class$org$exolab$castor$xml$schema$Schema = Schema.class$("org.exolab.castor.xml.schema.Schema")) : class$org$exolab$castor$xml$schema$Schema).getName() + "#";
    private static SimpleTypesFactory simpleTypesFactory = new SimpleTypesFactory();
    private Form _attributeFormDefault = null;
    private Hashtable _attributeGroups = null;
    private Hashtable _attributes = new Hashtable();
    private BlockList _block = null;
    private Hashtable _complexTypes = null;
    private Form _elementFormDefault = null;
    private Hashtable _elements = null;
    private FinalList _final = null;
    private Hashtable _groups = null;
    private String _id = null;
    private Hashtable _importedSchemas = null;
    private Vector _includedSchemas = null;
    private Hashtable _namespaces = null;
    private String _schemaLocation = null;
    private String _schemaNamespace = null;
    private Hashtable _simpleTypes = null;
    private String _targetNamespace = null;
    private String _version = null;
    static /* synthetic */ Class class$org$exolab$castor$xml$schema$Schema;

    public Schema() {
        this(DEFAULT_SCHEMA_NS);
    }

    public Schema(String string) {
        this._attributeGroups = new Hashtable();
        this._complexTypes = new Hashtable();
        this._simpleTypes = new Hashtable();
        this._elements = new Hashtable();
        this._groups = new Hashtable();
        this._importedSchemas = new Hashtable();
        this._includedSchemas = new Vector();
        this._namespaces = new Hashtable();
        this._schemaNamespace = string;
        if (this._schemaNamespace == null) {
            this._schemaNamespace = DEFAULT_SCHEMA_NS;
        }
        this.addNamespace("", this._schemaNamespace);
        this.init();
    }

    private void init() {
    }

    public void addAttribute(AttributeDecl attributeDecl) throws SchemaException {
        if (attributeDecl == null) {
            return;
        }
        String string = attributeDecl.getName();
        if (attributeDecl.getSchema() != this) {
            String string2 = "invalid attempt to add an AttributeDecl which ";
            string2 = string2 + "belongs to a different Schema; " + string;
            throw new SchemaException(string2);
        }
        if (string == null && attributeDecl.isReference()) {
            String string3 = "Error attempting to add a top-level AttributeDecl that is a reference. Top-level attributes can only be attribute declarations: " + attributeDecl.getName(false);
            throw new SchemaException(string3);
        }
        Object v = this._attributes.get(string);
        if (v == attributeDecl) {
            return;
        }
        if (v != null) {
            String string4 = "Error attempting to add an AttributeDecl to this Schema definition, an AttributeDecl already exists with the given name: ";
            throw new SchemaException(string4 + string);
        }
        this._attributes.put(string, attributeDecl);
    }

    public void addAttributeGroup(AttributeGroupDecl attributeGroupDecl) throws SchemaException {
        String string;
        String string2;
        if (attributeGroupDecl == null) {
            return;
        }
        String string3 = attributeGroupDecl.getName();
        int n = string3.indexOf(58);
        if (n >= 0) {
            string2 = string3.substring(0, n);
            string3 = string3.substring(n + 1);
            string = (String)this._namespaces.get(string2);
            if (string == null) {
                String string4 = "addAttributeGroup: ";
                string4 = string4 + "Namespace prefix not recognized '" + string2 + "'";
                throw new IllegalArgumentException(string4);
            }
            if (!string.equals(this._targetNamespace)) {
                String string5 = "AttributeGroup has different namespace than this Schema definition.";
                throw new IllegalArgumentException(string5);
            }
        }
        if (attributeGroupDecl.getSchema() != this) {
            string2 = "invalid attempt to add an AttributeGroup which ";
            string2 = string2 + "belongs to a different Schema; " + string3;
            throw new SchemaException(string2);
        }
        string2 = this._attributeGroups.get(string3);
        if (string2 == attributeGroupDecl) {
            return;
        }
        if (string2 != null) {
            string = "Error attempting to add an AttributeGroup to this Schema definition, an AttributeGroup already exists with the given name: ";
            throw new SchemaException(string + string3);
        }
        this._attributeGroups.put(string3, attributeGroupDecl);
    }

    public synchronized void addComplexType(ComplexType complexType) throws SchemaException {
        String string = complexType.getName();
        if (string == null) {
            String string2 = "a global ComplexType must contain a name.";
            throw new SchemaException(string2);
        }
        if (complexType.getSchema() != this) {
            String string3 = "invalid attempt to add an ComplexType which ";
            string3 = string3 + "belongs to a different Schema; type name: " + string;
            throw new SchemaException(string3);
        }
        if (this._complexTypes.get(string) != null) {
            String string4 = "a ComplexType already exists with the given name: ";
            throw new SchemaException(string4 + string);
        }
        this._complexTypes.put(string, complexType);
        complexType.setParent(this);
    }

    public void addElementDecl(ElementDecl elementDecl) throws SchemaException {
        String string = elementDecl.getName(true);
        if (string == null && elementDecl.isReference()) {
            String string2 = "Error attempting to add a top-level Element that is a reference. Top-level elements can only be element declarations: " + elementDecl.getName(false);
            throw new SchemaException(string2);
        }
        if (string == null) {
            String string3 = "an element declaration must contain a name.";
            throw new SchemaException(string3);
        }
        if (this._elements.get(string) != null) {
            String string4 = "an element declaration already exists with the given name: ";
            throw new SchemaException(string4 + string);
        }
        this._elements.put(string, elementDecl);
    }

    public void addModelGroup(ModelGroup modelGroup) throws SchemaException {
        String string = modelGroup.getName();
        if (string == null) {
            String string2 = "a group declaration must contain a name.";
            throw new SchemaException(string2);
        }
        if (this._groups.get(string) != null) {
            String string3 = "an group declaration already exists with the given name: ";
            throw new SchemaException(string3 + string);
        }
        this._groups.put(string, modelGroup);
    }

    public synchronized void addImportedSchema(Schema schema) throws SchemaException {
        String string = schema.getTargetNamespace();
        if (string == null) {
            string = "";
        }
        if (this._importedSchemas.get(string) != null) {
            String string2 = "a Schema has already been imported with the given namespace: ";
            throw new SchemaException(string2 + string);
        }
        this._importedSchemas.put(string, schema);
    }

    public void addNamespace(String string, String string2) {
        if (string == null) {
            string = "";
        }
        this._namespaces.put(string, string2);
    }

    public synchronized void addSimpleType(SimpleType simpleType) throws SchemaException {
        String string = simpleType.getName();
        if (string == null || string.length() == 0) {
            String string2 = "No name found for top-level SimpleType.  A top-level SimpleType must have a name.";
            throw new SchemaException(string2);
        }
        if (simpleType.getSchema() != this) {
            String string3 = "invalid attempt to add a SimpleType which ";
            string3 = string3 + "belongs to a different Schema; type name: " + string;
            throw new SchemaException(string3);
        }
        if (this._simpleTypes.get(string) != null) {
            String string4 = "a SimpleType already exists with the given name: ";
            throw new SchemaException(string4 + string);
        }
        simpleType.setParent(this);
        this._simpleTypes.put(string, simpleType);
    }

    public ComplexType createComplexType() {
        return new ComplexType(this);
    }

    public ComplexType createComplexType(String string) {
        return new ComplexType(this, string);
    }

    public SimpleType createSimpleType(String string, String string2, String string3) {
        return simpleTypesFactory.createUserSimpleType(this, string, string2, string3, true);
    }

    public SimpleType createSimpleType(String string, SimpleType simpleType) {
        return simpleTypesFactory.createUserSimpleType(this, string, simpleType, "restriction");
    }

    public Form getAttributeFormDefault() {
        return this._attributeFormDefault;
    }

    public Enumeration getAttributes() {
        return this._attributes.elements();
    }

    public AttributeDecl getAttribute(String string) {
        if (string == null) {
            String string2 = NULL_ARGUMENT + "getAttribute: ";
            string2 = string2 + "'name' cannot be null.";
            throw new IllegalArgumentException(string2);
        }
        String string3 = string;
        String string4 = "";
        String string5 = this._targetNamespace;
        int n = string.indexOf(58);
        if (n != -1) {
            string3 = string.substring(n + 1);
            string4 = string.substring(0, n);
            string5 = (String)this._namespaces.get(string4);
            if (string5 == null) {
                String string6 = "getAttribute: ";
                string6 = string6 + "Namespace prefix not recognized '" + string + "'";
                throw new IllegalArgumentException(string6);
            }
        }
        if (string5 == null || string5.equals(this._targetNamespace)) {
            return (AttributeDecl)this._attributes.get(string3);
        }
        Schema schema = this.getImportedSchema(string5);
        if (schema != null) {
            AttributeDecl attributeDecl = schema.getAttribute(string3);
            return attributeDecl;
        }
        return null;
    }

    public Enumeration getAttributeGroups() {
        return this._attributeGroups.elements();
    }

    public AttributeGroup getAttributeGroup(String string) {
        if (string == null) {
            String string2 = NULL_ARGUMENT + "getAttributeGroup: ";
            string2 = string2 + "'name' cannot be null.";
            throw new IllegalArgumentException(string2);
        }
        String string3 = string;
        String string4 = "";
        String string5 = this._targetNamespace;
        int n = string.indexOf(58);
        if (n != -1) {
            string3 = string.substring(n + 1);
            string4 = string.substring(0, n);
            string5 = (String)this._namespaces.get(string4);
            if (string5 == null) {
                String string6 = "getAttributeGroup: ";
                string6 = string6 + "Namespace prefix not recognized '" + string + "'";
                throw new IllegalArgumentException(string6);
            }
        }
        if (string5 == null || string5.equals(this._targetNamespace)) {
            return (AttributeGroup)this._attributeGroups.get(string3);
        }
        Schema schema = this.getImportedSchema(string5);
        if (schema != null) {
            return schema.getAttributeGroup(string3);
        }
        return null;
    }

    public BlockList getBlockDefault() {
        return this._block;
    }

    public String getBuiltInTypeName(int n) {
        return simpleTypesFactory.getBuiltInTypeName(n);
    }

    public ComplexType getComplexType(String string) {
        if (string == null) {
            String string2 = NULL_ARGUMENT + "getComplexType: ";
            string2 = string2 + "'name' cannot be null.";
            throw new IllegalArgumentException(string2);
        }
        String string3 = string;
        String string4 = "";
        String string5 = this._targetNamespace;
        int n = string.indexOf(58);
        if (n != -1) {
            string3 = string.substring(n + 1);
            string4 = string.substring(0, n);
            string5 = (String)this._namespaces.get(string4);
            if (string5 == null) {
                String string6 = "getComplexType: ";
                string6 = string6 + "Namespace prefix not recognized '" + string + "'";
                throw new IllegalArgumentException(string6);
            }
        }
        if (string5 == null || string5.equals(this._targetNamespace)) {
            return (ComplexType)this._complexTypes.get(string3);
        }
        Schema schema = this.getImportedSchema(string5);
        if (schema != null) {
            return schema.getComplexType(string3);
        }
        return null;
    }

    public Enumeration getComplexTypes() {
        return this._complexTypes.elements();
    }

    public ElementDecl getElementDecl(String string) {
        Object object;
        String string2 = null;
        if (string == null) {
            String string3 = NULL_ARGUMENT + "getElementDecl: ";
            string3 = string3 + " 'name' can not be null";
            throw new IllegalArgumentException(string3);
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            object = string.substring(0, n);
            string = string.substring(n + 1);
            string2 = (String)this._namespaces.get(object);
            if (string2 == null) {
                String string4 = "getElementDecl: ";
                string4 = string4 + "Namespace prefix not recognized '" + (String)object + "'";
                throw new IllegalArgumentException(string4);
            }
        }
        if (string2 == null || string2.equals(this._targetNamespace)) {
            return (ElementDecl)this._elements.get(string);
        }
        object = this.getImportedSchema(string2);
        if (object != null) {
            return ((Schema)object).getElementDecl(string);
        }
        return null;
    }

    public Enumeration getElementDecls() {
        return this._elements.elements();
    }

    public Form getElementFormDefault() {
        return this._elementFormDefault;
    }

    public FinalList getFinalDefault() {
        return this._final;
    }

    public SimpleType getSimpleType(String string) {
        if (string == null) {
            String string2 = NULL_ARGUMENT + "getSimpleType: ";
            string2 = string2 + "'name' cannot be null.";
            throw new IllegalArgumentException(string2);
        }
        String string3 = "";
        String string4 = null;
        int n = string.indexOf(58);
        if (n >= 0) {
            string3 = string.substring(0, n);
            string = string.substring(n + 1);
            string4 = (String)this._namespaces.get(string3);
            if (string4 == null) {
                String string5 = "getSimpleType: ";
                string5 = string5 + "Namespace prefix not recognised '" + string + "'";
                throw new IllegalArgumentException(string5);
            }
        }
        return this.getSimpleType(string, string4);
    }

    public SimpleType getSimpleType(String string, String string2) {
        if (string == null) {
            String string3 = NULL_ARGUMENT + "getSimpleType: ";
            string3 = string3 + "'name' cannot be null.";
            throw new IllegalArgumentException(string3);
        }
        boolean bl = false;
        if (string2 == null) {
            string2 = (String)this._namespaces.get("");
            bl = true;
        }
        SimpleType simpleType = null;
        if (string2 == null || bl) {
            simpleType = (SimpleType)this._simpleTypes.get(string);
            if (simpleType != null) {
                if (simpleType.getType() != simpleType && simpleType.getType() != null) {
                    simpleType = (SimpleType)simpleType.getType();
                    simpleType.setParent(this);
                    this._simpleTypes.put(string, simpleType);
                }
            } else {
                simpleType = simpleTypesFactory.getBuiltInType(string);
                if (simpleType != null && !this._schemaNamespace.equals(string2)) {
                    String string4 = "getSimpleType: the simple type '" + string + "' has not been declared in XML Schema namespace.";
                    throw new IllegalArgumentException(string4);
                }
            }
        } else if (string2.equals(this._schemaNamespace)) {
            simpleType = simpleTypesFactory.getBuiltInType(string);
            if (simpleType == null) {
                String string5 = "getSimpleType: the simple type '" + string + "' is not a built-in type as defined in XML Schema specification.";
                throw new IllegalArgumentException(string5);
            }
        } else if (string2.equals(this._targetNamespace)) {
            simpleType = (SimpleType)this._simpleTypes.get(string);
            if (simpleType != null && simpleType.getType() != simpleType && simpleType.getType() != null) {
                simpleType = (SimpleType)simpleType.getType();
                simpleType.setParent(this);
                this._simpleTypes.put(string, simpleType);
            }
        } else {
            Schema schema = this.getImportedSchema(string2);
            if (schema != null) {
                simpleType = schema.getSimpleType(string, string2);
            }
        }
        if (simpleType != null) {
            simpleType = (SimpleType)simpleType.getType();
        }
        return simpleType;
    }

    public Enumeration getSimpleTypes() {
        Enumeration enumeration = this._simpleTypes.elements();
        while (enumeration.hasMoreElements()) {
            SimpleType simpleType = (SimpleType)enumeration.nextElement();
            if (simpleType == simpleType.getType() || simpleType.getType() == null) continue;
            String string = simpleType.getName();
            simpleType = (SimpleType)simpleType.getType();
            simpleType.setParent(this);
            this._simpleTypes.put(string, simpleType);
        }
        return this._simpleTypes.elements();
    }

    public String getSchemaLocation() {
        return this._schemaLocation;
    }

    public ModelGroup getModelGroup(String string) {
        Object object;
        String string2 = null;
        if (string == null) {
            String string3 = NULL_ARGUMENT + "getModelGroup: ";
            string3 = string3 + " 'name' can not be null";
            throw new IllegalArgumentException(string3);
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            object = string.substring(0, n);
            string = string.substring(n + 1);
            string2 = (String)this._namespaces.get(object);
            if (string2 == null) {
                String string4 = "getModelGroup: ";
                string4 = string4 + "Namespace prefix not recognized '" + (String)object + "'";
                throw new IllegalArgumentException(string4);
            }
        }
        if (string2 == null || string2.equals(this._targetNamespace)) {
            return (ModelGroup)this._groups.get(string);
        }
        object = this.getImportedSchema(string2);
        if (object != null) {
            return ((Schema)object).getModelGroup(string);
        }
        return null;
    }

    public Enumeration getModelGroups() {
        return this._groups.elements();
    }

    public String getId() {
        return this._id;
    }

    public Enumeration getImportedSchema() {
        return this._importedSchemas.elements();
    }

    public Schema getImportedSchema(String string) {
        return (Schema)this._importedSchemas.get(string);
    }

    public final String getNamespace(String string) {
        if (string == null) {
            string = "";
        }
        return (String)this._namespaces.get(string);
    }

    public Hashtable getNamespaces() {
        return this._namespaces;
    }

    public void addInclude(String string) {
        this._includedSchemas.addElement(string);
    }

    public boolean includeProcessed(String string) {
        return this._includedSchemas.contains(string);
    }

    public String getSchemaNamespace() {
        return this._schemaNamespace;
    }

    public String getTargetNamespace() {
        return this._targetNamespace;
    }

    public String getVersion() {
        return this._version;
    }

    public boolean isKnownNamespace(String string) {
        Enumeration enumeration = this._namespaces.elements();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean removeComplexType(ComplexType complexType) {
        if (complexType.isTopLevel() && this._complexTypes.contains(complexType)) {
            this._complexTypes.remove(complexType.getName());
            complexType.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeElement(ElementDecl elementDecl) {
        if (this._elements.contains(elementDecl)) {
            this._elements.remove(elementDecl.getName());
            return true;
        }
        return false;
    }

    public boolean removeAttribute(AttributeDecl attributeDecl) {
        if (this._attributes.contains(attributeDecl)) {
            this._attributes.remove(attributeDecl.getName());
            return true;
        }
        return false;
    }

    public boolean removeGroup(ModelGroup modelGroup) {
        if (this._groups.contains(modelGroup)) {
            this._groups.remove(modelGroup.getName());
            return true;
        }
        return false;
    }

    public boolean removeSimpleType(SimpleType simpleType) {
        if (this._simpleTypes.contains(simpleType)) {
            this._simpleTypes.remove(simpleType.getName());
            return true;
        }
        return false;
    }

    public void setAttributeFormDefault(Form form) {
        this._attributeFormDefault = form;
    }

    public void setBlockDefault(BlockList blockList) {
        this._block = blockList;
    }

    public void setBlockDefault(String string) {
        this._block = new BlockList(string);
    }

    public void setElementFormDefault(Form form) {
        this._elementFormDefault = form;
    }

    public void setFinalDefault(FinalList finalList) {
        this._final = finalList;
    }

    public void setFinalDefault(String string) {
        this._final = new FinalList(string);
    }

    public void setSchemaLocation(String string) {
        this._schemaLocation = string;
    }

    public XMLType getType(String string) {
        if (string == null) {
            String string2 = NULL_ARGUMENT + "getSimpleType: ";
            string2 = string2 + "'name' cannot be null.";
            throw new IllegalArgumentException(string2);
        }
        XMLType xMLType = null;
        if (string.endsWith("anyType")) {
            String string3 = string;
            String string4 = "";
            String string5 = null;
            int n = string.indexOf(58);
            if (n >= 0) {
                string3 = string.substring(n + 1);
                string4 = string.substring(0, n);
                string5 = (String)this._namespaces.get(string4);
                if (string5 == null) {
                    String string6 = "getType: ";
                    string6 = string6 + "Namespace prefix not recognised '" + string + "'";
                    throw new IllegalArgumentException(string6);
                }
            }
            if (string5 == null) {
                string5 = (String)this._namespaces.get(string4);
            }
            if (string5.equals(DEFAULT_SCHEMA_NS)) {
                xMLType = new AnyType(this);
            }
        }
        if (xMLType == null) {
            xMLType = this.getSimpleType(string);
        }
        if (xMLType == null) {
            xMLType = this.getComplexType(string);
        }
        return xMLType;
    }

    public void setId(String string) {
        this._id = string;
    }

    public void setTargetNamespace(String string) {
        if (string != null && string.length() == 0) {
            throw new IllegalStateException("an empty string is not a valid namespace.");
        }
        this._targetNamespace = string;
    }

    public void setVersion(String string) {
        this._version = string;
    }

    static SimpleTypesFactory getTypeFactory() {
        return simpleTypesFactory;
    }

    public short getStructureType() {
        return 19;
    }

    public void validate() throws ValidationException {
        XMLType xMLType;
        Enumeration enumeration = this._complexTypes.elements();
        while (enumeration.hasMoreElements()) {
            xMLType = (ComplexType)enumeration.nextElement();
            ((ComplexType)xMLType).validate();
        }
        enumeration = this._simpleTypes.elements();
        while (enumeration.hasMoreElements()) {
            xMLType = (SimpleType)enumeration.nextElement();
            ((SimpleType)xMLType).validate();
        }
        enumeration = this._elements.elements();
        while (enumeration.hasMoreElements()) {
            ((ElementDecl)enumeration.nextElement()).validate();
        }
        enumeration = this._attributes.elements();
        while (enumeration.hasMoreElements()) {
            ((AttributeDecl)enumeration.nextElement()).validate();
        }
        enumeration = this._groups.elements();
        while (enumeration.hasMoreElements()) {
            ((Group)enumeration.nextElement()).validate();
        }
    }

    private String getNamespacePrefix(String string) {
        if (string == null) {
            return null;
        }
        Enumeration enumeration = this._namespaces.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.equals(this._namespaces.get(string2))) continue;
            return string2;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

