/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.GroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.WildcardUnmarshaller;

public class ComplexContentRestrictionUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private ComplexType _complexType = null;
    private Schema _schema = null;
    private String _id = null;
    private boolean foundAnnotation = false;
    private boolean foundAttribute = false;
    private boolean foundAnyAttribute = false;
    private boolean foundAttributeGroup = false;
    private boolean foundModelGroup = false;

    public ComplexContentRestrictionUnmarshaller(ComplexType complexType, AttributeSet attributeSet, Resolver resolver) throws XMLException {
        this.setResolver(resolver);
        this._complexType = complexType;
        this._schema = complexType.getSchema();
        this._complexType.setDerivationMethod("restriction");
        this._complexType.setRestriction(true);
        this._id = attributeSet.getValue("id");
        String string = attributeSet.getValue("base");
        if (string != null && string.length() > 0) {
            XMLType xMLType = this._schema.getType(string);
            if (xMLType == null) {
                this._complexType.setBase(string);
            } else {
                if (xMLType.isSimpleType()) {
                    String string2 = "complexType: " + this._complexType.getName() != null ? this._complexType.getName() : "\n";
                    string2 = string2 + "A complex type cannot be a restriction of a simpleType.";
                    throw new IllegalStateException(string2);
                }
                if (!xMLType.isAnyType() && ((ComplexType)xMLType).isRestricted()) {
                    String string3 = "complexType: " + this._complexType.getName() != null ? this._complexType.getName() : "\n";
                    string3 = string3 + "A complex type cannot be a restriction of a restriction.";
                    throw new IllegalStateException(string3);
                }
            }
            this._complexType.setBaseType(xMLType);
        }
    }

    public String elementName() {
        return "restriction";
    }

    public Object getObject() {
        return null;
    }

    public void startElement(String string, String string2, AttributeSet attributeSet, Namespaces namespaces) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, string2, attributeSet, namespaces);
            ++this.depth;
            return;
        }
        if (string.equals("annotation")) {
            if (this.foundModelGroup || this.foundAttribute || this.foundAttributeGroup) {
                this.error("An annotation must appear as the first child of 'restriction' elements.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of 'restriction' elements.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeSet);
        } else if (SchemaNames.isGroupName(string)) {
            if (this.foundAttribute || this.foundAttributeGroup) {
                this.error("'" + string + "' must appear before any attribute " + "definitions when a child of 'restriction'.");
            }
            if (this.foundModelGroup) {
                this.error("'" + string + "' cannot appear as a child of 'restriction' " + "if another 'all', 'sequence', 'choice' or " + "'group' also exists.");
            }
            this.foundModelGroup = true;
            this.unmarshaller = new GroupUnmarshaller(this._schema, string, attributeSet, this.getResolver());
        } else if ("attribute".equals(string)) {
            this.foundAttribute = true;
            this.unmarshaller = new AttributeUnmarshaller(this._schema, attributeSet, this.getResolver());
        } else if ("attributeGroup".equals(string)) {
            if (attributeSet.getValue("ref") == null) {
                this.error("A 'complexType' may contain referring attributeGroups, but not defining ones.");
            }
            this.foundAttributeGroup = true;
            this.unmarshaller = new AttributeGroupUnmarshaller(this._schema, attributeSet);
        } else if ("anyAttribute".equals(string)) {
            this.foundAnyAttribute = true;
            this.unmarshaller = new WildcardUnmarshaller(this._complexType, this._schema, string, attributeSet, this.getResolver());
        } else {
            this.illegalElement(string);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String string, String string2) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string, string2);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(string)) {
            Annotation annotation = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._complexType.addAnnotation(annotation);
        } else if ("anyAttribute".equals(string)) {
            Wildcard wildcard = ((WildcardUnmarshaller)this.unmarshaller).getWildcard();
            try {
                this._complexType.setAnyAttribute(wildcard);
            }
            catch (SchemaException schemaException) {
                throw new IllegalArgumentException(schemaException.getMessage());
            }
        } else if ("attribute".equals(string)) {
            AttributeDecl attributeDecl = ((AttributeUnmarshaller)this.unmarshaller).getAttribute();
            this._complexType.addAttributeDecl(attributeDecl);
        } else if ("attributeGroup".equals(string)) {
            AttributeGroupReference attributeGroupReference = (AttributeGroupReference)this.unmarshaller.getObject();
            this._complexType.addAttributeGroupReference(attributeGroupReference);
        } else if (SchemaNames.isGroupName(string)) {
            Group group = ((GroupUnmarshaller)this.unmarshaller).getGroup();
            this._complexType.addGroup(group);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

