/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.svgeditor.items;

import cx.ath.kgslab.svgeditor.items.ClosedItem;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class Rect
extends ClosedItem {
    public static final String ELEMENT_NAME = "rect";
    protected int width = 0;
    protected int height = 0;
    protected Rectangle2D shape = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);

    public Shape getShape() {
        if (this.changed) {
            int x = this.width < 0 ? this.x + this.width : this.x;
            int y = this.height < 0 ? this.y + this.height : this.y;
            this.shape.setRect(x, y, Math.abs(this.width), Math.abs(this.height));
            this.changed = false;
        }
        return this.shape;
    }

    public String getSvgElement() {
        int x = this.width < 0 ? this.x + this.width : this.x;
        int y = this.height < 0 ? this.y + this.height : this.y;
        StringBuffer buf = new StringBuffer();
        buf.append("<").append(ELEMENT_NAME);
        buf.append(" x='").append(x).append("'");
        buf.append(" y='").append(y).append("'");
        buf.append(" width='").append(Math.abs(this.width)).append("'");
        buf.append(" height='").append(Math.abs(this.height)).append("'");
        buf.append(" fill='").append(this.getFillString()).append("'");
        buf.append(" stroke='").append(this.getColorString()).append("'");
        buf.append(" stroke-width='").append(this.lineWidth).append("'/>");
        return buf.toString();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int i) {
        this.height = i;
        this.changed = true;
    }

    public void setWidth(int i) {
        this.width = i;
        this.changed = true;
    }

    public void form(int x, int y) {
        int w = x - this.getX();
        int h = y - this.getY();
        this.setWidth(w);
        this.setHeight(h);
    }

    public void initSample(int width, int height) {
        int x = width / 2;
        int y = height / 2;
        int n = y / 3 * 2;
        this.setX(x - n);
        this.setY(y - n);
        this.setWidth(n * 2);
        this.setHeight(n * 2);
    }
}

