/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.svgeditor.items;

import cx.ath.kgslab.svgeditor.items.ClosedItem;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class Ellipse
extends ClosedItem {
    public static final String ELEMENT_NAME = "ellipse";
    protected int rx = 0;
    protected int ry = 0;
    protected Ellipse2D shape = new Ellipse2D.Double(0.0, 0.0, 0.0, 0.0);

    public Shape getShape() {
        if (this.changed) {
            this.shape.setFrame(this.x - this.rx, this.y - this.ry, this.rx * 2, this.ry * 2);
            this.changed = false;
        }
        return this.shape;
    }

    public String getSvgElement() {
        StringBuffer buf = new StringBuffer();
        buf.append("<").append(ELEMENT_NAME);
        buf.append(" cx='").append(this.x).append("'");
        buf.append(" cy='").append(this.y).append("'");
        buf.append(" rx='").append(this.rx).append("'");
        buf.append(" ry='").append(this.ry).append("'");
        buf.append(" fill='").append(this.getFillString()).append("'");
        buf.append(" stroke='").append(this.getColorString()).append("'");
        buf.append(" stroke-width='").append(this.lineWidth).append("'/>");
        return buf.toString();
    }

    public int getRx() {
        return this.rx;
    }

    public int getRy() {
        return this.ry;
    }

    public void setRx(int i) {
        this.rx = i;
        this.changed = true;
    }

    public void setRy(int i) {
        this.ry = i;
        this.changed = true;
    }

    public void form(int x, int y) {
        int rx = x - this.getX();
        int ry = y - this.getY();
        this.setRx(Math.abs(rx));
        this.setRy(Math.abs(ry));
    }

    public void initSample(int width, int height) {
        int x = width / 2;
        int y = height / 2;
        int m = x / 3 * 2;
        int n = y / 3 * 2;
        this.setX(x);
        this.setY(y);
        this.setRx(m);
        this.setRy(n);
    }
}

