/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.webutil.axis.server;

import cx.ath.kgslab.webutil.axis.server.AxisExporter;
import cx.ath.kgslab.webutil.axis.server.SerializerSetting;
import cx.ath.kgslab.webutil.axis.server.SpringRPCProvider;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.server.ServletEndpointContext;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringBeanHandler
extends BasicHandler {
    private final Map soapServices = new HashMap();
    private WebApplicationContext webApplicationContext = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void invoke(MessageContext msgContext) throws AxisFault {
        try {
            this.setupService(msgContext);
        }
        catch (Exception e) {
            BasicHandler.log.error((Object)Messages.getMessage((String)"exception00"), (Throwable)e);
            throw AxisFault.makeFault((Exception)e);
        }
    }

    protected void setupService(MessageContext msgContext) throws Exception {
        String componentName;
        if (this.webApplicationContext == null) {
            ServletEndpointContext servletEndpointContext = (ServletEndpointContext)msgContext.getProperty("servletEndpointContext");
            ServletContext servletContext = servletEndpointContext.getServletContext();
            this.webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        }
        if ((componentName = this.getComponentName(msgContext)) == null) {
            return;
        }
        msgContext.setService(this.getService(msgContext, componentName));
    }

    protected String getComponentName(MessageContext msgContext) {
        String pathInfo = (String)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO);
        if (pathInfo == null || pathInfo.length() == 0) {
            return null;
        }
        return "@" + pathInfo.substring(1).replace('/', '.');
    }

    protected SOAPService getService(MessageContext msgContext, String componentName) throws AxisFault {
        SOAPService soapService = (SOAPService)this.soapServices.get(componentName);
        if (soapService == null) {
            soapService = this.createService(msgContext, componentName);
            this.soapServices.put(componentName, soapService);
        }
        soapService.setEngine(msgContext.getAxisEngine());
        soapService.init();
        return soapService;
    }

    protected SOAPService createService(MessageContext msgContext, String componentName) throws AxisFault {
        SOAPService soapService = new SOAPService((Handler)new SpringRPCProvider());
        Object bean = this.webApplicationContext.getBean(componentName);
        if (bean instanceof AxisExporter) {
            AxisExporter exporter = (AxisExporter)bean;
            Class<?> beanClass = exporter.getBean().getClass();
            String componentClassName = beanClass.getName();
            soapService.setName(componentClassName);
            soapService.setOption("className", (Object)componentClassName);
            soapService.setOption("applicationContext", (Object)this.webApplicationContext);
            soapService.setOption("componentName", (Object)componentName);
            soapService.getInitializedServiceDesc(msgContext);
            TypeMappingRegistry regs = msgContext.getTypeMappingRegistry();
            SerializerSetting[] settings = exporter.getSerializerSettings();
            int i = 0;
            while (i < settings.length) {
                this.registerTypeMapping(settings[i], regs);
                ++i;
            }
        }
        return soapService;
    }

    private void registerTypeMapping(SerializerSetting setting, TypeMappingRegistry regs) {
        QName qname;
        Class clazz = setting.getBeanClass();
        String namespace = this.getNamespaceFromClass(clazz);
        org.apache.axis.encoding.TypeMapping mapping = (org.apache.axis.encoding.TypeMapping)regs.getTypeMapping(namespace);
        if (mapping == null) {
            mapping = (org.apache.axis.encoding.TypeMapping)regs.createTypeMapping();
            regs.register(namespace, (TypeMapping)mapping);
        }
        if (!mapping.isRegistered(clazz, qname = this.getQNameFromClass(clazz))) {
            Class deserializer;
            Class serializer = setting.getSeralizerClass();
            if (serializer == null) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.apache.axis.encoding.ser.BeanSerializerFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                serializer = clazz2;
            }
            if ((deserializer = setting.getDeserializerClass()) == null) {
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("org.apache.axis.encoding.ser.BeanDeserializerFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                deserializer = clazz3;
            }
            mapping.register(clazz, qname, (SerializerFactory)BaseSerializerFactory.createFactory((Class)serializer, (Class)clazz, (QName)qname), (DeserializerFactory)BaseDeserializerFactory.createFactory((Class)deserializer, (Class)clazz, (QName)qname));
        }
    }

    private String getNamespaceFromClass(Class type) {
        return Namespaces.makeNamespace((String)type.getName());
    }

    private QName getQNameFromClass(Class type) {
        String name = type.getName();
        return new QName(this.getNamespaceFromClass(type), name.substring(name.lastIndexOf(46) + 1));
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        try {
            this.setupService(msgContext);
        }
        catch (Exception e) {
            BasicHandler.log.error((Object)Messages.getMessage((String)"exception00"), (Throwable)e);
            throw AxisFault.makeFault((Exception)e);
        }
    }
}

