/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class PathMatchingResourcePatternResolver
implements ResourcePatternResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ResourceLoader resourceLoader;
    private final ClassLoader classLoader;

    public PathMatchingResourcePatternResolver() {
        this.resourceLoader = new DefaultResourceLoader();
        this.classLoader = null;
    }

    public PathMatchingResourcePatternResolver(ClassLoader classLoader) {
        this.resourceLoader = new DefaultResourceLoader(classLoader);
        this.classLoader = classLoader;
    }

    public PathMatchingResourcePatternResolver(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.classLoader = null;
    }

    public PathMatchingResourcePatternResolver(ResourceLoader resourceLoader, ClassLoader classLoader) {
        this.resourceLoader = resourceLoader;
        this.classLoader = classLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        if (locationPattern.startsWith("classpath*:")) {
            return this.findAllClassPathResources(locationPattern.substring("classpath*:".length()));
        }
        if (PathMatcher.isPattern(locationPattern)) {
            return this.findPathMatchingFileResources(locationPattern);
        }
        return new Resource[]{this.resourceLoader.getResource(locationPattern)};
    }

    protected Resource[] findAllClassPathResources(String location) throws IOException {
        ClassLoader cl;
        String path = location;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((cl = this.classLoader) == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        Enumeration<URL> resourceUrls = cl.getResources(path);
        ArrayList<UrlResource> result = new ArrayList<UrlResource>();
        while (resourceUrls.hasMoreElements()) {
            URL url = resourceUrls.nextElement();
            result.add(new UrlResource(url));
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected Resource[] findPathMatchingFileResources(String locationPattern) throws IOException {
        ArrayList<FileSystemResource> result = new ArrayList<FileSystemResource>();
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        File rootDir = this.resourceLoader.getResource(rootDirPath).getFile().getAbsoluteFile();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for matching resources in directory tree [" + rootDir.getPath() + "]"));
        }
        List matchingFiles = this.retrieveMatchingFiles(rootDir, subPattern);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Resolved location pattern [" + locationPattern + "] to file paths: " + matchingFiles));
        }
        Iterator it = matchingFiles.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            result.add(new FileSystemResource(file));
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected String determineRootDir(String location) {
        int rootDirEnd;
        int patternStart = location.length();
        int asteriskIndex = location.indexOf(42);
        int questionMarkIndex = location.indexOf(63);
        if (asteriskIndex != -1 || questionMarkIndex != -1) {
            patternStart = asteriskIndex > questionMarkIndex ? asteriskIndex : questionMarkIndex;
        }
        return (rootDirEnd = location.lastIndexOf(47, patternStart)) != -1 ? location.substring(0, rootDirEnd) : "";
    }

    protected List retrieveMatchingFiles(File rootDir, String pattern) throws IOException {
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException("'rootDir' parameter [" + rootDir + "] does not denote a directory");
        }
        String fullPattern = StringUtils.replace(rootDir.getAbsolutePath(), File.separator, "/");
        if (!pattern.startsWith("/")) {
            fullPattern = fullPattern + "/";
        }
        fullPattern = fullPattern + StringUtils.replace(pattern, File.separator, "/");
        ArrayList result = new ArrayList();
        this.doRetrieveMatchingFiles(fullPattern, rootDir, result);
        return result;
    }

    protected void doRetrieveMatchingFiles(String fullPattern, File dir, List result) throws IOException {
        File[] dirContents;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Searching directory [" + dir.getAbsolutePath() + "] for files matching pattern [" + fullPattern + "]"));
        }
        if ((dirContents = dir.listFiles()) == null) {
            throw new IOException("Could not retrieve contents of directory [" + dir.getAbsolutePath() + "]");
        }
        boolean dirDepthNotFixed = fullPattern.indexOf("**") != -1;
        for (int i = 0; i < dirContents.length; ++i) {
            String currPath = StringUtils.replace(dirContents[i].getAbsolutePath(), File.separator, "/");
            if (dirContents[i].isDirectory() && (dirDepthNotFixed || StringUtils.countOccurrencesOf(currPath, "/") < StringUtils.countOccurrencesOf(fullPattern, "/"))) {
                this.doRetrieveMatchingFiles(fullPattern, dirContents[i], result);
            }
            if (!PathMatcher.match(fullPattern, currPath)) continue;
            result.add(dirContents[i]);
        }
    }
}

