/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.spring.axis.server;

import cx.ath.kgslab.spring.axis.TypeMappingDefinition;
import cx.ath.kgslab.spring.axis.server.AxisExporter;
import cx.ath.kgslab.spring.axis.server.SpringRPCProvider;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.rpc.server.ServletEndpointContext;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Messages;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringBeanHandler
extends BasicHandler {
    private static final Map soapServices = new HashMap();
    private WebApplicationContext webApplicationContext = null;

    public void invoke(MessageContext msgContext) throws AxisFault {
        try {
            this.setupService(msgContext);
        }
        catch (Exception e) {
            BasicHandler.log.error((Object)Messages.getMessage((String)"exception00"), (Throwable)e);
            throw AxisFault.makeFault((Exception)e);
        }
    }

    protected void setupService(MessageContext msgContext) throws Exception {
        String componentName;
        if (this.webApplicationContext == null) {
            ServletEndpointContext servletEndpointContext = (ServletEndpointContext)msgContext.getProperty("servletEndpointContext");
            ServletContext servletContext = servletEndpointContext.getServletContext();
            this.webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        }
        if ((componentName = this.getComponentName(msgContext)) == null) {
            return;
        }
        SOAPService service = this.getService(msgContext, componentName);
        if (service != null) {
            msgContext.setService(service);
        }
    }

    protected String getComponentName(MessageContext msgContext) {
        String pathInfo = (String)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO);
        if (pathInfo == null || pathInfo.length() == 0) {
            return null;
        }
        return "@" + pathInfo.substring(1).replace('/', '.');
    }

    protected SOAPService getService(MessageContext msgContext, String componentName) throws AxisFault {
        SOAPService soapService = (SOAPService)soapServices.get(componentName);
        if (soapService == null) {
            soapService = this.createService(msgContext, componentName);
            soapServices.put(componentName, soapService);
        }
        soapService.setEngine(msgContext.getAxisEngine());
        soapService.init();
        return soapService;
    }

    protected SOAPService createService(MessageContext msgContext, String componentName) throws AxisFault {
        Object bean = this.webApplicationContext.getBean(componentName);
        SOAPService soapService = null;
        if (bean instanceof AxisExporter) {
            AxisExporter exporter = (AxisExporter)bean;
            soapService = this.createExportService(msgContext, componentName, exporter);
            this.setTypeMapping(msgContext, exporter);
        }
        return soapService;
    }

    private SOAPService createExportService(MessageContext msgContext, String componentName, AxisExporter exporter) throws AxisFault {
        SOAPService soapService = new SOAPService((Handler)new SpringRPCProvider());
        Class<?> beanClass = exporter.getBean().getClass();
        String componentClassName = beanClass.getName();
        soapService.setName(componentClassName);
        soapService.setOption("className", (Object)componentClassName);
        soapService.setOption("applicationContext", (Object)this.webApplicationContext);
        soapService.setOption("componentName", (Object)componentName);
        String allowedMethods = this.getAllowedMethod(exporter);
        soapService.setOption("allowedMethods", (Object)allowedMethods);
        soapService.getInitializedServiceDesc(msgContext);
        return soapService;
    }

    private void setTypeMapping(MessageContext msgContext, AxisExporter exporter) throws AxisFault {
        TypeMappingRegistry regs = msgContext.getTypeMappingRegistry();
        Object[] typeMappings = exporter.getTypeMappings();
        int i = 0;
        while (i < typeMappings.length) {
            try {
                TypeMappingDefinition.registerTypeMapping(regs, typeMappings[i]);
            }
            catch (ClassNotFoundException e) {
                throw AxisFault.makeFault((Exception)e);
            }
            ++i;
        }
    }

    private String getAllowedMethod(AxisExporter exporter) {
        int i;
        HashSet<String> set = new HashSet<String>();
        String[] methods = exporter.getAllowedMethods();
        Class[] interfaces = exporter.getAllowedInterfaces();
        if (methods != null && methods.length > 0) {
            i = 0;
            while (i < methods.length) {
                set.add(methods[i]);
                ++i;
            }
        }
        if (interfaces != null && interfaces.length > 0) {
            i = 0;
            while (i < interfaces.length) {
                Class itfc = interfaces[i];
                this.getPublicMethodSetFromInterface(set, itfc);
                ++i;
            }
        }
        return this.createAllowedMethodsString(set);
    }

    private String createAllowedMethodsString(Set set) {
        if (!set.isEmpty() && !set.contains("*")) {
            StringBuffer buf = new StringBuffer();
            Iterator ite = set.iterator();
            while (ite.hasNext()) {
                String method = (String)ite.next();
                buf.append(method).append(' ');
            }
            String result = buf.toString().trim();
            if (result.length() > 0) {
                return result;
            }
        }
        return "*";
    }

    private void getPublicMethodSetFromInterface(Set set, Class itfc) {
        Method[] mthds;
        if (itfc.isInterface() && (mthds = itfc.getMethods()) != null && mthds.length > 0) {
            int j = 0;
            while (j < mthds.length) {
                Method method = mthds[j];
                if ((method.getModifiers() & 1) != 0) {
                    set.add(method.getName());
                }
                ++j;
            }
        }
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        try {
            this.setupService(msgContext);
        }
        catch (Exception e) {
            BasicHandler.log.error((Object)Messages.getMessage((String)"exception00"), (Throwable)e);
            throw AxisFault.makeFault((Exception)e);
        }
    }
}

