/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Axis" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
/*
 * $Id: TypeMappingDefinition.java,v 1.2 2004/12/08 10:29:09 mashu Exp $
 */
package cx.ath.kgslab.spring.axis;

import javax.xml.namespace.QName;

import org.apache.axis.Constants;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.wsdl.fromJava.Namespaces;


/**
 * ^Cv}bsO`.
 *
 * @author NAGASAWA Takahiro
 * @version $Revision: 1.2 $
 */
public class TypeMappingDefinition {
  private Class type = null;
  private String localName = null;
  private String namespace = null;
  private Class seralizerClass = null;
  private Class deserializerClass = null;
  private String encodingStyle = null;

  /**
   * @return Returns the encodingStyle.
   */
  public String getEncodingStyle() {
    return encodingStyle;
  }

  /**
   * SOAPGR[fBOX^CURIݒ肷.
   * @param encodingStyle The encodingStyle to set.
   */
  public void setEncodingStyle(String encodingStyle) {
    this.encodingStyle = encodingStyle;
  }

  /**
   * @return Returns the type.
   */
  public Class getType() {
    return type;
  }

  /**
   * ^Cv}bsOKvȃNXݒ肷.
   * @param type The type to set.
   */
  public void setType(Class type) {
    this.type = type;
  }

  /**
   * @return Returns the namespace.
   */
  public String getNamespace() {
    return namespace;
  }

  /**
   * ^Cv̖OԂݒ肷.
   * @param namespace The namespace to set.
   */
  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }

  /**
   * @return Returns the localName.
   */
  public String getLocalName() {
    return localName;
  }

  /**
   * ^CvLocal Nameݒ肷.
   * @param localName The localName to set.
   */
  public void setLocalName(String localName) {
    this.localName = localName;
  }

  /**
   * @return Returns the deserializerClass.
   */
  public Class getDeserializerClass() {
    return deserializerClass;
  }

  /**
   * ^CṽfVACUNXݒ肷.
   * @param deserializerClass The deserializerClass to set.
   */
  public void setDeserializerClass(Class deserializerClass) {
    this.deserializerClass = deserializerClass;
  }

  /**
   * @return Returns the seralizerClass.
   */
  public Class getSeralizerClass() {
    return seralizerClass;
  }

  /**
   * ^CṽVACUNXݒ肷.
   * @param seralizerClass The seralizerClass to set.
   */
  public void setSeralizerClass(Class seralizerClass) {
    this.seralizerClass = seralizerClass;
  }

  /**
   * ^Cv}bsO̓o^.
   * @param regs o^^Cv}bsOWXg
   */
  public void registerTypeMapping(TypeMappingRegistry regs) {
    final QName qname = createQName();

    String encstyle = null;

    if ((this.encodingStyle != null)
          && (this.encodingStyle.length() > 0)
          && Constants.isSOAP_ENC(this.encodingStyle)) {
      encstyle = this.encodingStyle;
    } else {
      encstyle = Constants.URI_DEFAULT_SOAP_ENC;
    }

    TypeMapping mapping = regs.getOrMakeTypeMapping(encstyle);

    if (!mapping.isRegistered(type, qname)) {
      Class serializer = this.getSeralizerClass();

      if (serializer == null) {
        serializer = BeanSerializerFactory.class;
      }

      Class deserializer = this.getDeserializerClass();

      if (deserializer == null) {
        deserializer = BeanDeserializerFactory.class;
      }

      mapping.register(type, qname,
        BaseSerializerFactory.createFactory(serializer, type,
          qname),
        BaseDeserializerFactory.createFactory(deserializer,
          type, qname));
    }
  }

  /**
   * QName𐶐
   * @return ꂽQName
   */
  private QName createQName() {
    QName qname;
    final boolean isSetNS =
      ((this.namespace != null) && (this.namespace.length() > 0));
    final boolean isSetLN =
      ((this.localName != null) && (this.localName.length() > 0));

    if (isSetNS && isSetLN) {
      qname = new QName(this.namespace, this.localName);
    } else if (isSetNS) {
      qname =
        new QName(this.namespace, getLocalNameFromClass(type));
    } else if (isSetLN) {
      qname =
        new QName(getNamespaceFromClass(type), this.localName);
    } else {
      qname = TypeMappingDefinition.getQNameFromClass(type);
    }
    return qname;
  }

  private static String getNamespaceFromClass(Class type) {
    return Namespaces.makeNamespace(type.getName());
  }

  private static QName getQNameFromClass(Class type) {
    return new QName(getNamespaceFromClass(type),
      getLocalNameFromClass(type));
  }

  /**
   * @param type
   * @return localName
   */
  private static String getLocalNameFromClass(Class type) {
    String name = type.getName();

    return name.substring(name.lastIndexOf('.') + 1);
  }

  /**
   * @param regs
   * @param temp
   * @throws ClassNotFoundException
   */
  public static void registerTypeMapping(
    final TypeMappingRegistry regs, Object temp)
    throws ClassNotFoundException {
    TypeMappingDefinition typemapping = null;

    if (temp instanceof TypeMappingDefinition) {
      typemapping = (TypeMappingDefinition) temp;
    } else {
      typemapping = new TypeMappingDefinition();

      if (temp instanceof Class) {
        typemapping.setType((Class) temp);
      } else if (temp instanceof String) {
        typemapping.setType(ClassUtils.forName((String) temp));
      } else {
        typemapping.setType(temp.getClass());
      }
    }

    typemapping.registerTypeMapping(regs);
  }
}
