/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Axis" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
/*
 * $Id: AxisInvocationInterceptor.java,v 1.1 2004/11/29 14:49:40 mashu Exp $
 */
package cx.ath.kgslab.spring.axis.client;

import java.lang.reflect.Method;

import javax.xml.namespace.QName;
import javax.xml.rpc.Call;

import org.apache.axis.client.Service;
import org.apache.axis.encoding.TypeMappingRegistry;

import cx.ath.kgslab.spring.axis.TypeMappingDefinition;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;


/**
 * IďoC^tF[X̃C^[Zv^.
 * S2AxisDynamicInvocationInterceptorQlɎB
 * @author NAGASAWA Takahiro
 * @version $Revision: 1.1 $
 */
public class AxisInvocationInterceptor
  implements MethodInterceptor, InitializingBean,
    BeanFactoryAware {
  private Service service = null;
  private String url = null;
  private Object[] typeMappings = null;
  private BeanFactory beanFactory = null;

  /**
   * RXgN^.
   */
  public AxisInvocationInterceptor() {
  }

  /**
   * IďoɕKvȁAT[rXIuWFNgݒ肷.
   * @param service The service to set.
   */
  public void setService(Service service) {
    this.service = service;
  }

  /**
   * ΏۃEFuT[rXURLݒ肷.
   * @param url The url to set.
   */
  public void setUrl(String url) {
    this.url = url;
  }

  /**
   * \bhďoT[rX̌Ăяoɕϊ.
   * @param invocation \bhďo
   */
  public Object invoke(final MethodInvocation invocation)
    throws Throwable {
    final Method method = invocation.getMethod();
    final Call call = (Call) service.createCall();
    call.setTargetEndpointAddress(url);
    call.setOperationName(new QName("http://soapinterop.org/",
        method.getName()));

    return call.invoke(invocation.getArguments());
  }

  /**
   * .
   * ^Cv}bsO`T[rXIuWFNgɔfB
   * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
   */
  public void afterPropertiesSet() throws Exception {
    if (service == null) {
      Object bean = null;

      if (beanFactory.containsBean("service")
            && (bean = beanFactory.getBean("service")) instanceof Service) {
        service = (Service) bean;
      } else {
        service = new Service();
      }
    }

    if ((typeMappings != null) && (typeMappings.length > 0)) {
      TypeMappingRegistry regs =
        (TypeMappingRegistry) service.getTypeMappingRegistry();

      for (int i = 0; i < typeMappings.length; i++) {
        TypeMappingDefinition.registerTypeMapping(regs,
          typeMappings[i]);
      }
    }
  }

  /**
   * ^Cv}bsO`ݒ肷.
   * @param typeMappings The serializerSettings to set.
   */
  public void setTypeMappings(Object[] typeMappings) {
    this.typeMappings = typeMappings;
  }

  /**
   * @see org.springframework.beans.factory.BeanFactoryAware#setBeanFactory(org.springframework.beans.factory.BeanFactory)
   */
  public void setBeanFactory(BeanFactory beanFactory)
    throws BeansException {
    this.beanFactory = beanFactory;
  }
}
