/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Axis" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
/*
 * $Id: AxisProxyFactoryBean.java,v 1.2 2004/12/08 10:29:09 mashu Exp $
 */
package cx.ath.kgslab.spring.axis.client;

import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;


/**
 * EFuT[rXIďovLVt@Ng.
 * ^ꂽURL̃T[rXA
 * ^ꂽC^tF[XŌĂяo߂
 * vLVIuWFNg𐶐B
 * <br>
 * ݒ:
<pre>
 &lt;bean id="test" class="cx.ath.kgslab.spring.axis.client.AxisProxyFactoryBean"&gt;
  &lt;!-- T[rX̃C^[tFCX --&gt;
  &lt;property name="serviceInterface"&gt;
   &lt;value&gt;cx.ath.kgslab.test.TestService&lt;/value&gt;
  &lt;/property&gt;
  &lt;!-- T[rXJĂURL --&gt;
  &lt;property name="url"&gt;
   &lt;value&gt;http://localhost:8080/SpringAxisTest/services/test&lt;/value&gt;
  &lt;/property&gt;
  &lt;!-- RPCIsɕKvServiceNX(ȗ) --&gt;
  &lt;property name="service"&gt;
   &lt;bean class="org.apache.axis.client.Service"/&gt;
  &lt;/property&gt;
  &lt;!-- ^Cv}bsOKvȃNX --&gt;
  &lt;property name="typeMappings"&gt;
   &lt;value&gt;cx.ath.kgslab.test.data.TestData&lt;/value&gt;
  &lt;/property&gt;
 &lt;/bean&gt;
</pre>
 * ̃T[rXJꍇɂ́A
 * servicẽvpeB͒beanݒ肷̂ł͂ȂA
 * ʓrbeanݒ肵āAt@Xݒ肷悤ɂقB
 * <br>
 * typeMappings̃vpeBɂ́A
 * BeanSerializerŏł悤ȒPBeanł΃NXŁA
 * ^Cv}bsOݒ肪IB
 * VACUAfVACUʓrݒ肷Kv΁A
 * TypeMappingDefinitiongpďڍׂȐݒsƂłB
 *
 * @author NAGASAWA Takahiro
 * @version $Revision: 1.2 $
 */
public class AxisProxyFactoryBean
  extends AxisInvocationInterceptor implements FactoryBean {
  private Class serviceInterface = null;

  /**
   * T[rXĂяoC^tF[X.
   * @param serviceInterface The serviceInterface to set.
   */
  public void setServiceInterface(Class serviceInterface) {
    this.serviceInterface = serviceInterface;
  }

  /**
   * @see org.springframework.beans.factory.FactoryBean#getObject()
   */
  public Object getObject() throws Exception {
    return ProxyFactory.getProxy(serviceInterface, this);
  }

  /**
   * @see org.springframework.beans.factory.FactoryBean#getObjectType()
   */
  public Class getObjectType() {
    return serviceInterface;
  }

  /**
   * @see org.springframework.beans.factory.FactoryBean#isSingleton()
   */
  public boolean isSingleton() {
    return true;
  }
}
