/*
 * Copyright  2004-2005 The KGS Lab. / NAGASAWA Takahiro
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
/*
 * $Id: SpringAxisService.java,v 1.3 2005/04/28 01:13:28 mashu Exp $
 */
package cx.ath.kgslab.spring.axis;

import org.apache.axis.AxisEngine;
import org.apache.axis.Handler;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.deployment.wsdd.WSDDChain;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.deployment.wsdd.WSDDRequestFlow;
import org.apache.axis.deployment.wsdd.WSDDResponseFlow;

import cx.ath.kgslab.spring.axis.deployment.WSDDSpringHandler;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;


/**
 * ServicebvāASpringAxis̏s߂̃NXB
 *
 * @author NAGASAWA Takahiro
 */
public class SpringAxisService extends Service
  implements InitializingBean, ApplicationContextAware {
  private ApplicationContext context = null;
  private Handler[] requestFlow = null;
  private Handler[] responseFlow = null;

  /**
   *
   */
  public SpringAxisService() {
    super();
  }

  /**
   * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
   */
  public void afterPropertiesSet() throws Exception {
    AxisEngine engine = this.getEngine();
    WSDDEngineConfiguration configuration =
      (WSDDEngineConfiguration) engine.getConfig();
    WSDDDeployment deployment = configuration.getDeployment();

    WSDDGlobalConfiguration globalConfig =
      new WSDDGlobalConfiguration();
    WSDDRequestFlow wsddRequestFlow = new WSDDRequestFlow();
    globalConfig.setRequestFlow(wsddRequestFlow);
    addToChain(wsddRequestFlow, requestFlow);

    WSDDResponseFlow wsddResponseFlow = new WSDDResponseFlow();
    globalConfig.setResponseFlow(wsddResponseFlow);
    addToChain(wsddResponseFlow, responseFlow);

    deployment.setGlobalConfiguration(globalConfig);
    globalConfig.deployToRegistry(deployment);
  }

  /**
   * @param deployment
   * @param context
   * @param exporter
   * @param deployer
   */
  private void addToChain(WSDDChain chain, Handler[] handlers) {
    if (handlers != null) {
      for (int i = 0; i < handlers.length; i++) {
        Handler element = (Handler) handlers[i];
        final WSDDSpringHandler handler =
          new WSDDSpringHandler(element);
        chain.addHandler(handler);
      }
    }
  }

  /**
   * @see org.springframework.context.ApplicationContextAware#setApplicationContext(org.springframework.context.ApplicationContext)
   */
  public void setApplicationContext(ApplicationContext context)
    throws BeansException {
    this.context = context;
  }

  /**
   * @return Returns the requestFlow.
   */
  public final Handler[] getRequestFlow() {
    return requestFlow;
  }

  /**
   * @param requestFlow The requestFlow to set.
   */
  public final void setRequestFlow(Handler[] requestFlow) {
    this.requestFlow = requestFlow;
  }

  /**
   * @return Returns the responseFlow.
   */
  public final Handler[] getResponseFlow() {
    return responseFlow;
  }

  /**
   * @param responseFlow The responseFlow to set.
   */
  public final void setResponseFlow(Handler[] responseFlow) {
    this.responseFlow = responseFlow;
  }
}
