/*
 * Copyright  2004-2005 The KGS Lab. / NAGASAWA Takahiro
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
/*
 * $Id: SpringAxisServlet.java,v 1.3 2005/04/28 01:13:28 mashu Exp $
 */
package cx.ath.kgslab.spring.axis;

import java.util.Iterator;
import java.util.Map;

import javax.servlet.ServletException;

import org.apache.axis.AxisFault;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.server.AxisServer;

import cx.ath.kgslab.spring.axis.deployer.Deployer;
import cx.ath.kgslab.spring.axis.deployer.HandlerDeployer;
import cx.ath.kgslab.spring.axis.deployer.ServiceDeployer;
import cx.ath.kgslab.spring.axis.deployer.WSDDDeployer;
import cx.ath.kgslab.spring.axis.exporter.AxisExporter;
import cx.ath.kgslab.spring.axis.exporter.AxisHandlerExporter;
import cx.ath.kgslab.spring.axis.exporter.AxisServiceExporter;
import cx.ath.kgslab.spring.axis.exporter.AxisWsddExporter;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;


/**
 * AxisServletgASpringAxis̏s悤ɂNX.
 * ̓Iɂ́AT[rXAnhAWSDDt@C̃T[rXւ̑gݍ݂A
 * Springs悤ɁANSpringݒǂݍނ悤ɂȂĂB
 *
 * @author NAGASAWA Takahiro
 */
public class SpringAxisServlet
  extends org.apache.axis.transport.http.AxisServlet {
  
  /* (non-Javadoc)
   * @see javax.servlet.GenericServlet#init()
   */
  public void init() throws ServletException {
    super.init();

    try {
      WebApplicationContext beanContext =
        WebApplicationContextUtils
        .getRequiredWebApplicationContext(getServletContext());
      AxisServer engine = this.getEngine();
      WSDDEngineConfiguration configuration =
        (WSDDEngineConfiguration) engine.getConfig();
      WSDDDeployment deployment = configuration.getDeployment();

      Map exporter =
        beanContext.getBeansOfType(AxisServiceExporter.class,
          true, true);

      if (!exporter.isEmpty()) {
        Deployer deployer = new ServiceDeployer();
        deploy(deployment, deployer, exporter);
      }

      exporter =
        beanContext.getBeansOfType(AxisHandlerExporter.class,
          true, true);

      if (!exporter.isEmpty()) {
        Deployer deployer = new HandlerDeployer();
        deploy(deployment, deployer, exporter);
      }

      exporter =
        beanContext.getBeansOfType(AxisWsddExporter.class, true,
          true);

      if (!exporter.isEmpty()) {
        Deployer deployer = new WSDDDeployer();
        deploy(deployment, deployer, exporter);
      }
    } catch (AxisFault e) {
      throw new ServletException(e);
    }
  }

  /**
   * @param deployment
   * @param context
   * @param exporter
   * @param deployer
   */
  private void deploy(WSDDDeployment deployment,
    Deployer deployer, Map exporter) {
    deployer.setContext(this.getServletContext());
    deployer.setDeployment(deployment);

    Iterator iteServices = exporter.values().iterator();

    while (iteServices.hasNext()) {
      AxisExporter element = (AxisExporter) iteServices.next();
      deployer.deploy(element);
    }
  }
}
