/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * $Id: HandlerDeployer.java,v 1.5 2005/04/01 01:29:57 mashu Exp $
 */
package cx.ath.kgslab.spring.axis.deployer;

import javax.servlet.ServletContext;

import org.apache.axis.deployment.wsdd.WSDDDeployment;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import cx.ath.kgslab.spring.axis.deployment.WSDDSpringHandler;
import cx.ath.kgslab.spring.axis.exporter.AxisHandlerExporter;
import cx.ath.kgslab.spring.axis.exporter.AxisExporter;


/**
 * AxisExporterɎw肳ꂽR|[lgnhƂAxisɃfvC܂B
 *
 * @author koichik/NAGASAWA Takahiro
 */
public class HandlerDeployer implements Deployer {
  //class fields
  private final static Log logger =
    LogFactory.getLog(HandlerDeployer.class);
  private WSDDDeployment deployment = null;

  /**
   * @param deployment The deployment to set.
   */
  public final void setDeployment(WSDDDeployment deployment) {
    this.deployment = deployment;
  }

  /**
   * R|[lgnhƂăfvC܂B
   *
   * @param arg
   */
  public void deploy(AxisExporter arg) {
    if (!(arg instanceof AxisHandlerExporter)) {
      throw new IllegalArgumentException();
    }

    AxisHandlerExporter exporter = (AxisHandlerExporter) arg;
    final WSDDSpringHandler handler =
      new WSDDSpringHandler(exporter);
    deployment.deployHandler(handler);

    if (logger.isDebugEnabled()) {
      logger.debug("handler deployed : " + handler.getQName());
    }
  }

  /**
   * @param servletContext
   */
  public void setContext(ServletContext servletContext) {
    // TODO Auto-generated method stub
  }
}
