/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * $Id: ServiceDeployer.java,v 1.6 2005/04/27 09:43:28 mashu Exp $
 */
package cx.ath.kgslab.spring.axis.deployer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletContext;

import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.utils.XMLUtils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import cx.ath.kgslab.spring.axis.DeployFailedException;
import cx.ath.kgslab.spring.axis.deployment.WSDDSpringService;
import cx.ath.kgslab.spring.axis.exporter.AxisServiceExporter;
import cx.ath.kgslab.spring.axis.exporter.AxisExporter;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


/**
 * AxisExporterɎw肳ꂽR|[lgT[rXƂAxisɃfvC܂B
 *
 * @author koichik/NAGASAWA Takahiro
 */
public class ServiceDeployer implements Deployer {
  //class fields
  private final static Log logger =
    LogFactory.getLog(ServiceDeployer.class);
  private ServletContext context = null;
  private WSDDDeployment deployment = null;

  /**
   * R|[lgT[rXƂăfvC܂B
   *
   * @param exporter T[rX`
   */
  public void deploy(final AxisExporter arg) {
    if (!(arg instanceof AxisServiceExporter)) {
      throw new IllegalArgumentException();
    }

    AxisServiceExporter exporter = (AxisServiceExporter) arg;
    final WSDDSpringService service =
      createWSDDSpringService(exporter);
    deployment.deployService(service);

    if (logger.isDebugEnabled()) {
      logger.debug("service deployed : " + service.getQName());
    }
  }

  /**
   * <code>WSDDSpringService</code> CX^XĕԂ܂B <br>
   * ^f[^̎wɏ]A <code>ServiceDef</code> ܂WSDDt@C
   * <code>WSDDSpringService</code> CX^X܂B
   *
   * @param componentDef
   *            R|[lg`
   * @param metaDef
   *            ^f[^`
   * @return <code>WSDDSpringService</code>
   */
  protected WSDDSpringService createWSDDSpringService(
    final AxisServiceExporter exporter) {
    WSDDSpringService result = null;
    try {
      String wsddFileName = exporter.getWsddFileName();

      if (wsddFileName != null && wsddFileName.length() > 0) {
        File wsddFile =
          new File(this.context.getRealPath(wsddFileName));

        result = new WSDDSpringService(exporter,
          getServiceElement(wsddFile));
      } else {
        result = new WSDDSpringService(exporter);
      }
      return result;
    } catch (final WSDDException e) {
      throw new DeployFailedException(e);
    }
  }

  /**
   * WSDDt@Ct@CVXe܂̓NXpXǂݍ݁A <code>&lt;service&gt;</code> vfԂ܂B
   *
   * @param wsddFileName
   *            WSDDt@C̃pX
   * @return <code>&lt;service&gt;</code> vf
   */
  protected Element getServiceElement(final File wsddFile) {
    try {
      final InputStream is = new FileInputStream(wsddFile);
      final Element documentElement =
        XMLUtils.newDocument(is).getDocumentElement();
      final Element[] serviceElements =
        getChildElements(documentElement,
          WSDDConstants.ELEM_WSDD_SERVICE);

      if (serviceElements.length != 1) {
        throw new DeployFailedException("wsdd file missing : "
          + wsddFile.getPath());
      }

      return serviceElements[0];
    } catch (final DeployFailedException e) {
      throw e;
    } catch (final Exception e) {
      throw new DeployFailedException(e);
    }
  }

  /**
   * w肳ꂽ[Jqvf̔zԂ܂B
   *
   * @param parent
   *            evf
   * @param name
   *            qvf̃[J
   * @return w肳ꂽ[Jqvf̔zBYqvf݂Ȃꍇ͋̔zB
   */
  protected Element[] getChildElements(final Element parent,
    final String name) {
    final List result = new ArrayList();
    final NodeList children = parent.getChildNodes();

    for (int i = 0; i < children.getLength(); i++) {
      final Node thisNode = children.item(i);

      if (thisNode instanceof Element) {
        final Element element = (Element) thisNode;

        if (element.getLocalName().equals(name)) {
          result.add(element);
        }
      }
    }

    return (Element[]) result.toArray(new Element[result.size()]);
  }

  /**
   * @param context The context to set.
   */
  public final void setContext(ServletContext context) {
    this.context = context;
  }

  /**
   * @param deployment
   */
  public void setDeployment(WSDDDeployment deployment) {
    this.deployment = deployment;
  }
}
