/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * $Id: WSDDDeployer.java,v 1.5 2005/04/01 01:29:57 mashu Exp $
 */
package cx.ath.kgslab.spring.axis.deployer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import javax.servlet.ServletContext;

import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.utils.XMLUtils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import cx.ath.kgslab.spring.axis.DeployFailedException;
import cx.ath.kgslab.spring.axis.exporter.AxisWsddExporter;
import cx.ath.kgslab.spring.axis.exporter.AxisExporter;


/**
 * AxisExporterŎw肳ꂽWSDDt@CAxisɃfvC܂B
 *
 * @author koichik/NAGASAWA Takahiro
 */
public class WSDDDeployer implements Deployer {
  //class fields
  private final static Log logger =
    LogFactory.getLog(WSDDDeployer.class);
  private ServletContext context = null;
  private WSDDDeployment deployment = null;

  /**
   * ^Ŏw肳ꂽWSDDt@CfvC܂B
   *
   * @param componentDef
   *            R|[lg`
   * @param metaDef
   *            ^`
   */
  public void deploy(final AxisExporter arg) {
    if (!(arg instanceof AxisWsddExporter)) {
      throw new IllegalArgumentException();
    }

    AxisWsddExporter exporter = (AxisWsddExporter) arg;

    try {
      String wsddFileName = exporter.getWsddFileName();
      File wsddFile =
        new File(this.context.getRealPath(wsddFileName));

      final InputStream is = new FileInputStream(wsddFile);
      final WSDDDocument wsddDocument =
        new WSDDDocument(XMLUtils.newDocument(is));
      wsddDocument.deploy(deployment);

      if (logger.isDebugEnabled()) {
        logger.debug("WSDD file deployed : "
          + wsddFile.getPath());
      }
    } catch (final Exception e) {
      throw new DeployFailedException(e);
    }
  }

  /**
   * @param context The context to set.
   */
  public final void setContext(ServletContext context) {
    this.context = context;
  }

  /**
   * @param deployment
   */
  public void setDeployment(WSDDDeployment deployment) {
    this.deployment = deployment;
  }
}
