/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * $Id: WSDDSpringService.java,v 1.7 2005/04/27 09:43:28 mashu Exp $
 */
package cx.ath.kgslab.spring.axis.deployment;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMapping;

import org.apache.axis.Handler;
import org.apache.axis.constants.Use;
import org.apache.axis.deployment.wsdd.WSDDChain;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDRequestFlow;
import org.apache.axis.deployment.wsdd.WSDDResponseFlow;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.encoding.TypeMappingImpl;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.providers.java.JavaProvider;

import cx.ath.kgslab.spring.axis.SpringAxisConstants;
import cx.ath.kgslab.spring.axis.TypeMappingDefinition;
import cx.ath.kgslab.spring.axis.exporter.AxisServiceExporter;
import cx.ath.kgslab.spring.axis.register.TypeMappingRegister;

import org.w3c.dom.Element;


/**
 * SpringɂCX^XǗT[rXWSDDɂ\łB
 *
 * @author koichik/NAGASAWA Takahiro
 */
public class WSDDSpringService extends WSDDService {
  //static fields
  protected static final Map providerMapping = new HashMap();

  static {
    providerMapping.put(PROVIDER_RPC,
      SpringAxisConstants.PROVIDER_RPC);
    providerMapping.put(PROVIDER_MSG,
      SpringAxisConstants.PROVIDER_MSG);
  }

  private AxisServiceExporter serviceExporter;

  /**
   * T[rX`CX^X\z܂B
   *
   * @param serviceExporter T[rX`
   * @throws WSDDException
   *             CX^X̍\zɎsꍇɃX[܂B
   */
  public WSDDSpringService(
    final AxisServiceExporter serviceExporter)
    throws WSDDException {
    this.serviceExporter = serviceExporter;

    final String name = getName();
    setQName(new QName(name));

    final JavaServiceDesc serviceDesc =
      (JavaServiceDesc) getServiceDesc();
    serviceDesc.setName(name);

    Class serviceType = serviceExporter.getBean().getClass();

    setParameter(JavaProvider.OPTION_CLASSNAME,
      serviceType.getName());

    setProviderQName(new QName(WSDDConstants.URI_WSDD_JAVA,
        getSpringProvider(serviceExporter.getProvider())));

    final String[] allowedMethods =
      serviceExporter.getAllowedMethods();
    initAllowedMethods(serviceExporter, allowedMethods);

    Object[] typeMappingDefs = serviceExporter.getTypeMappings();
    initTypeMappings(serviceDesc, typeMappingDefs);

    Handler[] requestFlow = serviceExporter.getRequestFlow();
    this.setRequestFlow((WSDDRequestFlow) initChain(
        new WSDDRequestFlow(), requestFlow));

    Handler[] responseFlow = serviceExporter.getResponseFlow();
    this.setResponseFlow((WSDDResponseFlow) initChain(
        new WSDDResponseFlow(), responseFlow));
  }

  /**
   * R|[lg`WSDDt@C(XML)DOMc[CX^X\z܂B <br>
   * WSDD <code>&lt;service&gt;</code> vf <code>provider</code>
   * Ŏw肳ꂽvoC_ΉS2Axis̃voC_ɕύX܂B
   *
   * @param serviceExporter
   *            T[rX`
   * @param serviceElement
   *            WSDDt@C(XML)DOMc[
   * @throws WSDDException
   *             CX^X̍\zɎsꍇɃX[܂B
   */
  public WSDDSpringService(
    final AxisServiceExporter serviceExporter,
    final Element serviceElement) throws WSDDException {
    super(serviceElement);
    this.serviceExporter = serviceExporter;

    final String provider = getProviderQName().getLocalPart();
    setProviderQName(new QName(WSDDConstants.URI_WSDD_JAVA,
        getSpringProvider(provider)));
  }

  /**
   * @param chain
   * @param requestFlow
   */
  private WSDDChain initChain(WSDDChain chain, Handler[] handlers) {
    if (handlers != null) {
      for (int i = 0; i < handlers.length; i++) {
        chain.addHandler(new WSDDSpringHandler(handlers[i]));
      }
    }

    return chain;
  }

  /**
   * @param serviceExporter
   * @param allowedMethods
   */
  private void initAllowedMethods(
    final AxisServiceExporter axisExporter,
    final String[] allowedMethods) {
    if ((allowedMethods != null) && (allowedMethods.length > 0)) {
      setParameter(JavaProvider.OPTION_ALLOWEDMETHODS,
        getAllowedMethod(axisExporter));
    }
  }

  /**
   * @param serviceDesc
   * @param typeMappingDefs
   * @throws WSDDException
   */
  private void initTypeMappings(
    final JavaServiceDesc serviceDesc, Object[] typeMappingDefs)
    throws WSDDException {
    TypeMappingRegister register = new TypeMappingRegister();

    if (typeMappingDefs != null) {
      for (int i = 0; i < typeMappingDefs.length; i++) {
        TypeMappingDefinition typeMappingDef = null;

        if (typeMappingDefs[i] instanceof TypeMappingDefinition) {
          typeMappingDef =
            (TypeMappingDefinition) typeMappingDefs[i];
        } else {
          typeMappingDef = new TypeMappingDefinition();

          if (typeMappingDefs[i] instanceof Class) {
            typeMappingDef.setType((Class) typeMappingDefs[i]);
          } else {
            typeMappingDef.setType(typeMappingDefs[i].getClass());
          }
        }

        addTypeMapping(register.createWSDDTypeMapping(
            typeMappingDef));
      }
    }

    initTMR();
    validateDescriptors();

    final TypeMappingRegistry tmr =
      serviceDesc.getTypeMappingRegistry();
    TypeMapping tm =
      tmr.getTypeMapping(Use.DEFAULT.getEncoding());
    ((TypeMappingImpl) tm).setDoAutoTypes(true);
  }

  /**
   * T[rXԂ܂B <br>
   * T[rX́AR|[lg`ɖOԂw肳Ă"O/R|[lg"AłȂ"R|[lg"ɂȂ܂B
   *
   * @return T[rX
   */
  protected String getName() {
    final String componentName = serviceExporter.getBeanName();

    return componentName;
  }

  /**
   * Axis̃voC_ɑΉS2Axisp̃voC_Ԃ܂B
   *
   * @param provider
   *            AxisW̃voC_
   * @return SpringAxisp̃voC_
   * @throws WSDDException
   *             Axis̃voC_ΉSpringAxis̃voC_ȂꍇɃX[܂
   */
  protected String getSpringProvider(final String provider)
    throws WSDDException {
    final String s2Provider =
      (String) providerMapping.get(provider);

    if (s2Provider == null) {
      throw new WSDDException(provider);
    }

    return s2Provider;
  }

  /**
   * J\bhXg̍쐬
   * @param exporter T[rXJ
   * @return J\bh̃Xg(\bhuN؂ŗ)
   */
  private String getAllowedMethod(AxisServiceExporter exporter) {
    Set set = new HashSet();
    String[] methods = exporter.getAllowedMethods();
    Class[] interfaces = exporter.getAllowedInterfaces();

    if ((methods != null) && (methods.length > 0)) {
      for (int i = 0; i < methods.length; i++) {
        set.add(methods[i]);
      }
    }

    if ((interfaces != null) && (interfaces.length > 0)) {
      for (int i = 0; i < interfaces.length; i++) {
        Class itfc = interfaces[i];
        getPublicMethodSetFromInterface(set, itfc);
      }
    }

    return createAllowedMethodsString(set);
  }

  /**
   *
   * @param set J\bhW߂Set
   * @return
   */
  private String createAllowedMethodsString(Set set) {
    if (!set.isEmpty() && !set.contains("*")) {
      StringBuffer buf = new StringBuffer();
      Iterator ite = set.iterator();

      while (ite.hasNext()) {
        String method = (String) ite.next();
        buf.append(method).append(' ');
      }

      String result = buf.toString().trim();

      if (result.length() > 0) {
        return result;
      }
    }

    // w肪Ȃ܂"*"܂܂ꍇ"*"ԂB
    return "*";
  }

  /**
   * C^[tFCXJ\bh𒊏oB
   * @param set Public\bhW߂Set
   * @param itfc Ώۂ̃C^[tFCX
   */
  private void getPublicMethodSetFromInterface(Set set,
    Class itfc) {
    if (itfc.isInterface()) {
      Method[] mthds = itfc.getMethods();

      if ((mthds != null) && (mthds.length > 0)) {
        for (int j = 0; j < mthds.length; j++) {
          Method method = mthds[j];

          if ((method.getModifiers() & Modifier.PUBLIC) != 0) {
            set.add(method.getName());
          }
        }
      }
    }
  }

  /**
   * @return serviceExporter
   */
  public AxisServiceExporter getServiceExporter() {
    return serviceExporter;
  }
}
