/*
 * Copyright  2004-2005 The KGS Lab. / NAGASAWA Takahiro
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
/*
 * $Id: AxisServiceExporter.java,v 1.4 2005/04/28 01:13:28 mashu Exp $
 */
package cx.ath.kgslab.spring.axis.exporter;

import org.apache.axis.Handler;
import org.apache.axis.deployment.wsdd.WSDDService;

import org.springframework.beans.factory.BeanNameAware;


/**
 * T[rXƂČJBeanƃ\bh̃}[LOs߂̃NX.
 * T[rXƂČĴɕKvȏׂ͂ẴNXŐݒłB
 * ݒ:
<pre>
 &lt;bean id="test" class="cx.ath.kgslab.spring.axis.exporter.AxisServiceExporter"&gt;
  &lt;!-- T[rX̎Bean --&gt;
  &lt;property name="bean"&gt;
   &lt;bean class="cx.ath.kgslab.test.Test"/&lt;
  &lt;/property&gt;
  &lt;!-- J\bh --&gt;
  &lt;property name="allowedMethods"&gt;
   &lt;value&gt;test&lt;/value&gt;
  &lt;/property&gt;
  &lt;!-- JC^tF[X --&gt;
  &lt;property name="allowedInterfaces"&gt;
   &lt;value&gt;test&lt;/value&gt;
  &lt;/property&gt;
  &lt;!-- ^Cv}bsOKvȃNX --&gt;
  &lt;property name="typeMappings"&gt;
   &lt;value&gt;cx.ath.kgslab.test.data.TestData&lt;/value&gt;
  &lt;/property&gt;
 &lt;/bean&gt;
</pre>
 * <br>
 * beañvpeBɂ́A
 * T[rXۂɎĂBeanw肷B
 * <br>
 * allowedMethods/allowedInterfaces̃vpeBɂ́A
 * bean̎Ă郁\bh̓A
 * T[rXƂČJ\bhwłB
 * allowedMethodsł̓\bhA
 * allowedInterfacesł͌J郁\bh܂ރC^tF[Xw肷B
 * ǂw肪΁Abean̎publicȃ\bhׂĂJB
 * <br>
 * typeMappings̃vpeBɂ́A
 * BeanSerializerŏł悤ȒPBeanł΃NXŁA
 * ^Cv}bsOݒ肪IB܂AȂĂIɃ^Cv}bsȎΏۂƂȂB
 * VACUAfVACUʓrݒ肷Kv΁A
 * TypeMappingDefinitiongpďڍׂȐݒsƂłB
 * <br>

 *  * @author NAGASAWA Takahiro
 * @version $Revision: 1.4 $
 */
public class AxisServiceExporter implements BeanNameAware,
  AxisExporter {
  private Object bean = null;
  private String beanName = null;
  private Class[] allowedInterfaces = null;
  private String[] allowedMethods = null;
  private Object[] typeMappings = null;
  private String wsddFileName = null;
  private String provider = WSDDService.PROVIDER_RPC;
  private Handler[] requestFlow = null;
  private Handler[] responseFlow = null;

  /* (non-Javadoc)
   * @see org.springframework.beans.factory.BeanNameAware#setBeanName(java.lang.String)
   */
  public void setBeanName(String beanName) {
    this.beanName = beanName;
  }

  /**
   * @return Returns the beanName.
   */
  public final String getBeanName() {
    return beanName;
  }

  /**
   * @return Returns the bean.
   */
  public Object getBean() {
    return bean;
  }

  /**
   * T[rXƂČJBeanݒ肷.
   * @param bean The bean to set.
   */
  public void setBean(Object bean) {
    this.bean = bean;
  }

  /**
   * @return Returns the allowedMethods.
   */
  public String[] getAllowedMethods() {
    return allowedMethods;
  }

  /**
   * J\ȃ\bhݒ肷.
   * @param allowedMethods The allowedMethods to set.
   */
  public void setAllowedMethods(String[] allowedMethods) {
    this.allowedMethods = allowedMethods;
  }

  /**
   * @return Returns the typeMapping.
   */
  public Object[] getTypeMappings() {
    return typeMappings;
  }

  /**
   * ^Cv}bsOݒ肷.
   * @param typeMappings The typeMapping to set.
   */
  public void setTypeMappings(Object[] typeMappings) {
    this.typeMappings = typeMappings;
  }

  /**
   * @return Returns the allowedInterfaces.
   */
  public Class[] getAllowedInterfaces() {
    return allowedInterfaces;
  }

  /**
   * J\ȃC^[tFCXݒ肷.
   * @param allowedInterfaces The allowedInterfaces to set.
   */
  public void setAllowedInterfaces(Class[] allowedInterfaces) {
    this.allowedInterfaces = allowedInterfaces;
  }

  /**
   * @return Returns the wsddFileName.
   */
  public final String getWsddFileName() {
    return wsddFileName;
  }

  /**
   * @param wsddFileName The wsddFileName to set.
   */
  public final void setWsddFileName(String wsddFileName) {
    this.wsddFileName = wsddFileName;
  }

  /**
   * @return Returns the provider.
   */
  public final String getProvider() {
    return provider;
  }

  /**
   * @param provider The provider to set.
   */
  public final void setProvider(String provider) {
    this.provider = provider;
  }

  /**
   * @return Returns the requestFlow.
   */
  public final Handler[] getRequestFlow() {
    return requestFlow;
  }

  /**
   * @param requestFlow The requestFlow to set.
   */
  public final void setRequestFlow(Handler[] requestFlow) {
    this.requestFlow = requestFlow;
  }

  /**
   * @return Returns the responseFlow.
   */
  public final Handler[] getResponseFlow() {
    return responseFlow;
  }

  /**
   * @param responseFlow The responseFlow to set.
   */
  public final void setResponseFlow(Handler[] responseFlow) {
    this.responseFlow = responseFlow;
  }
}
