/*
 * Copyright  2004-2005 The KGS Lab. / NAGASAWA Takahiro
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
/*
 * $Id: AxisInvocationAdvisor.java,v 1.2 2005/04/28 01:13:28 mashu Exp $
 */
package cx.ath.kgslab.spring.axis.proxy;

import java.util.ArrayList;

import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.IntroductionAdvisor;

/**
 * T[rXɃvpeB@\D荞ނ߂̃AhoCU
 * 
 * @author NAGASAWA Takahiro
 */
public class AxisInvocationAdvisor implements IntroductionAdvisor {

  private static final ClassFilter CLASS_FILTER = new ClassFilter() {
    public boolean matches(Class arg0) {
      return true;
    }
  };

  private AxisInvocationInterceptor interceptor;
  private ArrayList interfaces = new ArrayList(2);
  /**
   * 
   */
  public AxisInvocationAdvisor() {
  }

  /**
   * @see org.springframework.aop.IntroductionAdvisor#getClassFilter()
   */
  public ClassFilter getClassFilter() {
    return CLASS_FILTER;
  }

  /**
   * @see org.springframework.aop.IntroductionAdvisor#validateInterfaces()
   */
  public void validateInterfaces() throws IllegalArgumentException {
  }

  /**
   * @see org.springframework.aop.Advisor#isPerInstance()
   */
  public boolean isPerInstance() {
    return true;
  }

  /**
   * @see org.springframework.aop.Advisor#getAdvice()
   */
  public Advice getAdvice() {
    return interceptor;
  }

  /**
   * @see org.springframework.aop.IntroductionInfo#getInterfaces()
   */
  public Class[] getInterfaces() {
    return (Class[])interfaces.toArray(new Class[interfaces.size()]);
  }

  /**
   * @param interceptor The interceptor to set.
   */
  public final void setInterceptor(AxisInvocationInterceptor interceptor) {
    this.interceptor = interceptor;
  }
  /**
   * @param arg0
   * @return
   */
  public boolean addInterface(Class clazz) {
    return interfaces.add(clazz);
  }
}
