/*
 * Copyright  2004-2005 The KGS Lab. / NAGASAWA Takahiro
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
/*
 * $Id: AxisInvocationInterceptor.java,v 1.4 2005/04/28 01:13:28 mashu Exp $
 */
package cx.ath.kgslab.spring.axis.proxy;

import java.lang.reflect.Method;

import java.util.Iterator;

import javax.xml.namespace.QName;
import javax.xml.rpc.Call;

import org.apache.axis.client.Service;

import org.aopalliance.intercept.MethodInvocation;

import org.springframework.aop.IntroductionInterceptor;


/**
 * IďoC^tF[X̃C^[Zv^.
 * S2AxisDynamicInvocationInterceptorQlɎB
 * @author NAGASAWA Takahiro
 * @version $Revision: 1.4 $
 */
public class AxisInvocationInterceptor
  implements IntroductionInterceptor {
  private Service service = null;
  private Class serviceInterface = null;
  private String url = null;

  /**
   * RXgN^.
   */
  public AxisInvocationInterceptor() {
  }

  /**
   * RXgN^.
   */
  public AxisInvocationInterceptor(Service service, String url,
    Class serviceInterface) {
    setService(service);
    setUrl(url);
  }

  /**
   * IďoɕKvȁAT[rXIuWFNgݒ肷.
   * @param service The service to set.
   */
  public void setService(Service service) {
    this.service = service;
  }

  /**
   * ΏۃEFuT[rXURLݒ肷.
   * @param url The url to set.
   */
  public void setUrl(String url) {
    this.url = url;
  }

  /**
   * @param serviceInterface The serviceInterface to set.
   */
  public final void setServiceInterface(Class serviceInterface) {
    this.serviceInterface = serviceInterface;
  }

  /**
   * \bhďoT[rX̌Ăяoɕϊ.
   * @param invocation \bhďo
   */
  public Object invoke(final MethodInvocation invocation)
    throws Throwable {
    final Method method = invocation.getMethod();
    final String methodname = method.getName();

    AxisInvocationProperties properties = null;

    if (invocation.getThis() instanceof AxisInvocationProperties) {
      properties =
        (AxisInvocationProperties) invocation.getThis();

      if ("getProperty".equals(methodname)) {
        return properties.getProperty((String) invocation
          .getArguments()[0]);
      } else if ("getPropertyNames".equals(methodname)) {
        return properties.getPropertyNames();
      } else if ("setProperty".equals(methodname)) {
        properties.setProperty((String) invocation.getArguments()[0],
          invocation.getArguments()[1]);

        return null;
      } else if ("removeProperty".equals(methodname)) {
        properties.removeProperty((String) invocation
          .getArguments()[0]);

        return null;
      }
    }

    final Call call = (Call) service.createCall();

    if (properties != null) {
      Iterator ite = properties.getPropertyNames();

      while (ite.hasNext()) {
        String key = (String) ite.next();
        call.setProperty(key, properties.getProperty(key));
      }
    }

    call.setTargetEndpointAddress(url);
    call.setOperationName(new QName("http://soapinterop.org/",
        method.getName()));

    return call.invoke(invocation.getArguments());
  }

  /**
   * @see org.springframework.aop.DynamicIntroductionAdvice#implementsInterface(java.lang.Class)
   */
  public boolean implementsInterface(Class clazz) {
    return serviceInterface.equals(clazz);
  }
}
