/*
 * Copyright  2004-2005 The KGS Lab. / NAGASAWA Takahiro
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
/*
 * $Id: AxisProxyFactoryBean.java,v 1.5 2005/04/28 01:13:28 mashu Exp $
 */
package cx.ath.kgslab.spring.axis.proxy;

import javax.xml.rpc.encoding.TypeMapping;

import org.apache.axis.client.Service;
import org.apache.axis.constants.Use;
import org.apache.axis.encoding.TypeMappingImpl;
import org.apache.axis.encoding.TypeMappingRegistry;

import cx.ath.kgslab.spring.axis.register.TypeMappingRegister;

import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.CommonsPoolTargetSource;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;


/**
 * EFuT[rXIďovLVt@Ng.
 * ^ꂽURL̃T[rXA
 * ^ꂽC^tF[XŌĂяo߂
 * vLVIuWFNg𐶐B
 * <br>
 * ݒ:
<pre>
 &lt;bean id="test" class="cx.ath.kgslab.spring.axis.proxy.AxisProxyFactoryBean"&gt;
  &lt;!-- T[rX̃C^[tFCX --&gt;
  &lt;property name="serviceInterface"&gt;
   &lt;value&gt;cx.ath.kgslab.test.TestService&lt;/value&gt;
  &lt;/property&gt;
  &lt;!-- T[rXJĂURL --&gt;
  &lt;property name="url"&gt;
   &lt;value&gt;http://localhost:8080/SpringAxisTest/services/test&lt;/value&gt;
  &lt;/property&gt;
  &lt;!-- RPCIsɕKvServiceNX(ȗ) --&gt;
  &lt;property name="service"&gt;
   &lt;bean class="org.apache.axis.client.Service"/&gt;
  &lt;/property&gt;
  &lt;!-- ^Cv}bsOKvȃNX --&gt;
  &lt;property name="typeMappings"&gt;
   &lt;value&gt;cx.ath.kgslab.test.data.TestData&lt;/value&gt;
  &lt;/property&gt;
  &lt;!-- vpeBݒǂ --&gt;
  &lt;property name="enableProperties"&gt;
   &lt;value&gt;true&lt;/value&gt;
  &lt;/property&gt;
 &lt;/bean&gt;
</pre>
 * ̃T[rXJꍇɂ́A
 * servicẽvpeB͒beanݒ肷̂ł͂ȂA
 * ʓrbeanݒ肵āAt@Xݒ肷悤ɂقB
 * <br>
 * typeMappings̃vpeBɂ́A
 * BeanSerializerŏł悤ȒPBeanł΃NXŁA
 * ^Cv}bsOݒ肪IB
 * VACUAfVACUʓrݒ肷Kv΁A
 * TypeMappingDefinitiongpďڍׂȐݒsƂłB
 * <br>
 * nhɃp[^n߂ȂǂɁA
 * vpeBݒ肵ꍇ́A
 * enablePropertiestrueɂB
 * ƃvLVIuWFNgAxisInvocationPropertiesp悤ɂȂ̂ŁA
 * LXgăvpeBݒ肷B
 *
 *
 * @author NAGASAWA Takahiro
 * @version $Revision: 1.5 $
 */
public class AxisProxyFactoryBean implements FactoryBean,
  InitializingBean, BeanFactoryAware {
  private static CommonsPoolTargetSource targetSource = null;
  private Class serviceInterface = null;
  private Service service = null;
  private String url = null;
  private Object[] typeMappings = null;
  private BeanFactory beanFactory = null;
  private ProxyFactory factory = null;
  private AxisInvocationInterceptor interceptor = null;
  private boolean enableProperties = false;

  /**
   * .
   * ^Cv}bsO`T[rXIuWFNgɔfB
   * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
   */
  public void afterPropertiesSet() throws Exception {
    if (service == null) {
      Object bean = null;

      if (beanFactory.containsBean("service")
            && (bean = beanFactory.getBean("service")) instanceof Service) {
        service = (Service) bean;
      } else {
        service = new Service();
      }
    }

    TypeMappingRegistry regs =
      (TypeMappingRegistry) service.getTypeMappingRegistry();
    TypeMappingRegister register = new TypeMappingRegister();

    if ((typeMappings != null) && (typeMappings.length > 0)) {
      for (int i = 0; i < typeMappings.length; i++) {
        register.registerTypeMapping(regs, typeMappings[i]);
      }
    }

    TypeMapping tm =
      regs.getTypeMapping(Use.DEFAULT.getEncoding());
    ((TypeMappingImpl) tm).setDoAutoTypes(true);
  }

  /**
   * ^Cv}bsO`ݒ肷.
   * @param typeMappings The serializerSettings to set.
   */
  public void setTypeMappings(Object[] typeMappings) {
    this.typeMappings = typeMappings;
  }

  /**
   * @see org.springframework.beans.factory.BeanFactoryAware#setBeanFactory(org.springframework.beans.factory.BeanFactory)
   */
  public void setBeanFactory(BeanFactory beanFactory)
    throws BeansException {
    this.beanFactory = beanFactory;
  }

  /**
   * IďoɕKvȁAT[rXIuWFNgݒ肷.
   * @param service The service to set.
   */
  public void setService(Service service) {
    this.service = service;
  }

  /**
   * ΏۃEFuT[rXURLݒ肷.
   * @param url The url to set.
   */
  public void setUrl(String url) {
    this.url = url;
  }

  /**
   * T[rXĂяoC^tF[X.
   * @param serviceInterface The serviceInterface to set.
   */
  public void setServiceInterface(Class serviceInterface) {
    this.serviceInterface = serviceInterface;
  }

  /**
   * @see org.springframework.beans.factory.FactoryBean#getObject()
   */
  public Object getObject() throws Exception {
    ProxyFactory factory = getProxyFactory();

    if (enableProperties) {
      factory.setTarget(new AxisInvocationPropertiesImpl());
    }

    return factory.getProxy();
  }

  /**
   *
   */
  private ProxyFactory getProxyFactory() {
    if (factory == null) {
      factory = new ProxyFactory();
      factory.addAdvisor(getAdvisor());
    }

    return factory;
  }

  /**
   * @return
   */
  private AxisInvocationAdvisor getAdvisor() {
    AxisInvocationAdvisor advisor = new AxisInvocationAdvisor();
    advisor.addInterface(serviceInterface);
    if (enableProperties) {
      advisor.addInterface(AxisInvocationProperties.class);
    }
    advisor.setInterceptor(getInterceptor());
    return advisor;
  }

  /**
   *
   */
  private AxisInvocationInterceptor getInterceptor() {
    if (interceptor == null) {
      interceptor =
        new AxisInvocationInterceptor(this.service, this.url,
          this.serviceInterface);
    }

    return interceptor;
  }

  /**
   * @see org.springframework.beans.factory.FactoryBean#getObjectType()
   */
  public Class getObjectType() {
    return serviceInterface;
  }

  /**
   * @see org.springframework.beans.factory.FactoryBean#isSingleton()
   */
  public boolean isSingleton() {
    return !enableProperties;
  }

  /**
   * @param enableProperties The enableProperties to set.
   */
  public final void setEnableProperties(boolean enableProperties) {
    this.enableProperties = enableProperties;
  }
}
