/*
*
* The Seasar Software License, Version 1.1
*
* Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
*
* Redistribution and use in source and binary forms, with or
* without modification, are permitted provided that the following
* conditions are met:
*
* 1. Redistributions of source code must retain the above
*    copyright notice, this list of conditions and the following
*    disclaimer.
*
* 2. Redistributions in binary form must reproduce the above
*    copyright notice, this list of conditions and the following
*    disclaimer in the documentation and/or other materials provided
*    with the distribution.
*
* 3. The end-user documentation included with the redistribution,
*    if any, must include the following acknowledgement:
*    "This product includes software developed by the
*    Seasar Project (http://www.seasar.org/)."
*    Alternately, this acknowledgement may appear in the software
*    itself, if and wherever such third-party acknowledgements
*    normally appear.
*
* 4. Neither the name "The Seasar Project" nor the names of its
*    contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission of
*    the Seasar Project.
*
* THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
* PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
* OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
* WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
* THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*
 * $Id: TypeMappingRegister.java,v 1.3 2005/04/01 01:36:44 mashu Exp $
 */
package cx.ath.kgslab.spring.axis.register;

import javax.xml.namespace.QName;

import org.apache.axis.Constants;
import org.apache.axis.deployment.wsdd.WSDDTypeMapping;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.Types;

import cx.ath.kgslab.spring.axis.TypeMappingDefinition;

/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 * 
 * @author NAGASAWA Takahiro
 */
public class TypeMappingRegister {

  /**
   * @param regs
   * @param temp
   * @throws ClassNotFoundException
   */
  public void registerTypeMapping(
    final TypeMappingRegistry regs, Object temp)
    throws ClassNotFoundException {
    TypeMappingDefinition typemapping = null;

    if (temp instanceof TypeMappingDefinition) {
      typemapping = (TypeMappingDefinition) temp;
    } else {
      typemapping = new TypeMappingDefinition();

      if (temp instanceof Class) {
        typemapping.setType((Class) temp);
      } else if (temp instanceof String) {
        typemapping.setType(ClassUtils.forName((String) temp));
      } else {
        typemapping.setType(temp.getClass());
      }
    }

    this.regist(regs, typemapping);
  }
  /**
   * WSDD^Cv}bsO쐬ĕԂ܂B
   *
   * @param typeMappingDef
   *            ^Cv}bsO`
   * @return WSDD^Cv}bsO
   */
  public WSDDTypeMapping createWSDDTypeMapping(
    final TypeMappingDefinition typeMappingDef) {
    final WSDDTypeMapping wsddTypeMapping =
      new WSDDTypeMapping();

    final Class type = typeMappingDef.getType();
    wsddTypeMapping.setLanguageSpecificType(typeMappingDef
      .getType());

    wsddTypeMapping.setQName(TypeMappingRegister.createQName(typeMappingDef));

    if (typeMappingDef.getSerializerClass() != null) {
      wsddTypeMapping.setSerializer(typeMappingDef
        .getSerializerClass());
    } else {
      wsddTypeMapping.setSerializer(BeanSerializerFactory.class);
    }

    if (typeMappingDef.getDeserializerClass() != null) {
      wsddTypeMapping.setDeserializer(typeMappingDef
        .getDeserializerClass());
    } else {
      wsddTypeMapping.setDeserializer(BeanDeserializerFactory.class);
    }

    if (typeMappingDef.getEncodingStyle() == null) {
      wsddTypeMapping.setEncodingStyle(Constants.URI_DEFAULT_SOAP_ENC);
    } else {
      wsddTypeMapping.setEncodingStyle(typeMappingDef
        .getEncodingStyle());
    }

    return wsddTypeMapping;
  }


  /**
   * ^Cv}bsO̓o^.
   * @param regs o^^Cv}bsOWXg
   */
  private void regist(TypeMappingRegistry regs, TypeMappingDefinition def) {
    final QName qname = createQName(def);

    String encstyle = null;

    if ((def.getEncodingStyle() != null)
          && (def.getEncodingStyle().length() > 0)
          && Constants.isSOAP_ENC(def.getEncodingStyle())) {
      encstyle = def.getEncodingStyle();
    } else {
      encstyle = Constants.URI_DEFAULT_SOAP_ENC;
    }

    TypeMapping mapping = regs.getOrMakeTypeMapping(encstyle);

    if (!mapping.isRegistered(def.getType(), qname)) {
      Class serializer = def.getSerializerClass();

      if (serializer == null) {
        serializer = BeanSerializerFactory.class;
      }

      Class deserializer = def.getDeserializerClass();

      if (deserializer == null) {
        deserializer = BeanDeserializerFactory.class;
      }

      mapping.register(def.getType(), qname,
        BaseSerializerFactory.createFactory(serializer, def.getType(),
          qname),
        BaseDeserializerFactory.createFactory(deserializer,
            def.getType(), qname));
    }
  }

  /**
   * QName𐶐
   * @return ꂽQName
   */
  public static QName createQName(TypeMappingDefinition def) {
    QName qname;

    if (((def.getNamespace() == null)
          || (def.getNamespace().length() <= 0))) {
      def.setNamespace(getNamespaceFromClass(def.getType()));
    }

    if ((def.getLocalName() == null)
          || (def.getLocalName().length() <= 0)) {
      def.setLocalName(getLocalNameFromClass(def.getType()));
    }

    if ((def.getNamespacePrefix() == null)
          || (def.getNamespacePrefix().length() <= 0)) {
      qname = new QName(def.getNamespace(), def.getLocalName());
    } else {
      qname =
        new QName(def.getNamespace(), def.getLocalName(),
            def.getNamespacePrefix());
    }

    return qname;
  }

  public static String getNamespaceFromClass(Class type) {
    return Namespaces.makeNamespace(type.getName());
  }

  /**
   * @param type
   * @return localName
   */
  public static String getLocalNameFromClass(Class type) {
    return Types.getLocalNameFromFullName(type.getName());
  }

}
